/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.activity;

import com.atlassian.fecru.user.UserProfile;
import com.atlassian.fecru.user.UserProfileManager;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.LoginCookie;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.CommandString;
import com.cenqua.fisheye.web.FishEyePathInfo;
import com.cenqua.fisheye.web.UrlHelper;
import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class RssFeedUrlBuilder {
    private final String baseUrl;
    private final HttpServletRequest request;
    private Map<String, String[]> rssQueryParameters;
    private String view = "all";
    private boolean authenticationRequired = true;
    private Integer maxItems;
    private FishEyePathInfo pathInfo;

    public RssFeedUrlBuilder(HttpServletRequest request, String baseUrl) {
        this.baseUrl = baseUrl;
        this.request = request;
    }

    public void setPathInfo(FishEyePathInfo pathInfo) {
        this.pathInfo = pathInfo;
    }

    public void setView(String view) {
        this.view = view;
    }

    public void setAuthenticationRequired(boolean authenticationRequired) {
        this.authenticationRequired = authenticationRequired;
    }

    public void setMaxItems(int maxItems) {
        this.maxItems = maxItems;
    }

    public void addRssQueryParameters(Map<String, String[]> rssQueryParameters) {
        this.rssQueryParameters = new HashMap<String, String[]>(rssQueryParameters);
    }

    public UrlHelper build() throws DbException {
        UserProfile profile;
        Path base;
        UrlHelper url = new UrlHelper();
        Path authBase = base = new Path(this.baseUrl);
        if (this.pathInfo != null) {
            String string;
            CommandString cs = this.pathInfo.getCommandString();
            if (cs != null && !Strings.isNullOrEmpty((String)(string = cs.toUrlString()))) {
                base = new Path(base, "~" + string);
            }
            if (this.pathInfo.getRepname() != null) {
                base = new Path(base, this.pathInfo.getRepname());
            }
            authBase = base;
            if (!this.pathInfo.getLocalPath().isRoot()) {
                base = new Path(base, this.pathInfo.getLocalPath());
            }
        }
        url.setUrl("/" + base.getPath());
        if (this.rssQueryParameters != null) {
            for (Map.Entry entry : this.rssQueryParameters.entrySet()) {
                String key = (String)entry.getKey();
                if (key.startsWith("@")) continue;
                url.putParam(key, (Object[])entry.getValue());
            }
        }
        UserManager um = AppConfig.getsConfig().getUserManager();
        UserProfileManager userProfileManager = AppConfig.getsConfig().getUserProfileManager();
        UserLogin user = um.getCurrentUser(this.request);
        UserProfile userProfile = profile = user == null ? userProfileManager.getDefaultProfile() : userProfileManager.getProfile(user.getUserName());
        if (!url.getParams().containsKey("view")) {
            url.putParam("view", this.view);
        }
        if (!url.getParams().containsKey("max")) {
            if (this.maxItems == null) {
                this.maxItems = profile.getChangesetsPerPage();
            }
            url.putParam("max", this.maxItems);
        }
        if (this.authenticationRequired && user != null) {
            LoginCookie lc = um.preCookUrl(this.request, "/" + authBase.getPath(), true);
            url.putParam("FEAUTH", lc.getLoginCookieToken().encode());
        }
        url.putParam("RSS", "true");
        return url;
    }
}

