/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.activity;

import com.cenqua.fisheye.Path;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;

public class RepositoryConstraints {
    private final Map<String, RepositoryConstraint> constraints = new HashMap<String, RepositoryConstraint>();
    private final Set<String> users = new HashSet<String>();

    public void addCommitter(String repName, String committer) {
        this.getOrCreateConstraint(repName).addCommitter(committer);
    }

    public void addUser(String user) {
        this.users.add(user);
    }

    public void includeRepository(String repName) {
        this.getOrCreateConstraint(repName).includeWholeRepository();
    }

    public void excludeRepository(String repName) {
        this.getOrCreateConstraint(repName).excludeWholeRepository();
    }

    public void addPath(String repName, String path) {
        this.getOrCreateConstraint(repName).addPath(new Path(path));
    }

    public boolean isIncludeWholeRepository(String repName) {
        RepositoryConstraint constraint = this.constraints.get(repName);
        return constraint != null && constraint.isIncludeWholeRepository();
    }

    public Iterable<RepositoryConstraint> getConstraints() {
        return this.constraints.values();
    }

    public Set<String> getReps() {
        return this.constraints.keySet();
    }

    public RepositoryConstraint getConstraintsForRep(String rep) {
        return this.constraints.get(rep);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    private RepositoryConstraint getOrCreateConstraint(String repName) {
        RepositoryConstraint constraint = this.constraints.get(repName);
        if (constraint == null) {
            constraint = new RepositoryConstraint(repName);
            this.constraints.put(repName, constraint);
        }
        return constraint;
    }

    public boolean isEmpty() {
        return this.constraints.isEmpty() && this.users.isEmpty();
    }

    public Set<String> getUsers() {
        return this.users;
    }

    public static class RepositoryConstraint {
        private String rep;
        private boolean includeWholeRep = false;
        private boolean excludeWholeRep = true;
        private final Set<String> committers = new HashSet<String>();
        private final Set<Path> paths = new HashSet<Path>();

        private RepositoryConstraint(String rep) {
            this.rep = rep;
        }

        private RepositoryConstraint addCommitter(String committer) {
            this.committers.add(committer);
            this.includeWholeRep = false;
            this.excludeWholeRep = false;
            return this;
        }

        private RepositoryConstraint addPath(Path newPath) {
            Iterator<Path> i2 = this.paths.iterator();
            while (i2.hasNext()) {
                Path current = i2.next();
                if (current.isAncestor(newPath)) {
                    return this;
                }
                if (!newPath.isAncestor(current)) continue;
                i2.remove();
            }
            this.paths.add(newPath);
            this.includeWholeRep = false;
            this.excludeWholeRep = false;
            return this;
        }

        private RepositoryConstraint includeWholeRepository() {
            this.includeWholeRep = true;
            this.excludeWholeRep = false;
            this.committers.clear();
            this.paths.clear();
            return this;
        }

        private RepositoryConstraint excludeWholeRepository() {
            this.includeWholeRep = false;
            this.excludeWholeRep = true;
            this.committers.clear();
            this.paths.clear();
            return this;
        }

        public String getRepository() {
            return this.rep;
        }

        public boolean isIncludeWholeRepository() {
            return this.includeWholeRep;
        }

        public boolean isExcludeWholeRepository() {
            return this.excludeWholeRep;
        }

        public Set<String> getCommitters() {
            return ImmutableSet.copyOf(this.committers);
        }

        public Set<Path> getPaths() {
            return ImmutableSet.copyOf(this.paths);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }
}

