/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.activity;

import com.atlassian.fisheye.activity.RepositoryConstraints;
import com.atlassian.fisheye.activity.StarActivityConstraintBuilder;
import com.atlassian.fisheye.stars.StarType;
import com.atlassian.fisheye.stars.model.CommitterStar;
import com.atlassian.fisheye.stars.model.DirectoryStar;
import com.atlassian.fisheye.stars.model.FileStar;
import com.atlassian.fisheye.stars.model.RepositoryStar;
import com.atlassian.fisheye.stars.model.Star;
import com.atlassian.fisheye.stars.model.StarList;
import com.atlassian.fisheye.stars.model.UserStar;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.DbException;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class RepositoryConstraintBuilder
implements StarActivityConstraintBuilder<RepositoryConstraints> {
    private StarList stars = new StarList();
    private RepositoryConstraints repositoryConstraints = new RepositoryConstraints();
    private CommitterUserMappingManager committerUserMappingManager;

    public RepositoryConstraintBuilder(CommitterUserMappingManager committerUserMappingManager) {
        this.committerUserMappingManager = committerUserMappingManager;
    }

    @Override
    public RepositoryConstraints getActivityItemParams() throws DbException {
        List fileStars = this.stars.getStarsOfType(StarType.FILE);
        for (Object star : fileStars) {
            this.repositoryConstraints.addPath(((FileStar)star).getRepName(), ((FileStar)star).getPath());
        }
        List directoryStars = this.stars.getStarsOfType(StarType.DIRECTORY);
        for (Object star : directoryStars) {
            this.repositoryConstraints.addPath(((DirectoryStar)star).getRepName(), ((DirectoryStar)star).getPath());
        }
        List committerStars = this.stars.getStarsOfType(StarType.COMMITTER);
        for (Object star : committerStars) {
            this.repositoryConstraints.addCommitter(((CommitterStar)star).getRepName(), ((CommitterStar)star).getCommitterName());
        }
        List userStars = this.stars.getStarsOfType(StarType.USER);
        for (UserStar star : userStars) {
            this.addUserStar(star);
        }
        List repositoryStars = this.stars.getStarsOfType(StarType.REPOSITORY);
        for (RepositoryStar star : repositoryStars) {
            this.repositoryConstraints.includeRepository(star.getRepName());
        }
        return this.repositoryConstraints;
    }

    @Override
    public void addStars(List<Star> stars) {
        this.stars.addStars(stars);
    }

    @Override
    public void addStar(Star star) {
        this.stars.addStar(star);
    }

    private void addUserStar(UserStar star) throws DbException {
        Multimap<String, String> repCommitters = this.committerUserMappingManager.getAllCommittersForUser(star.getFEUsername());
        for (Map.Entry entry : repCommitters.asMap().entrySet()) {
            for (String committer : (Collection)entry.getValue()) {
                this.repositoryConstraints.addCommitter((String)entry.getKey(), committer);
            }
        }
        this.repositoryConstraints.addUser(star.getFEUsername());
    }
}

