/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.activity;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.fisheye.activity.ActivityItem;
import com.atlassian.fisheye.activity.ActivityItemComparators;
import com.atlassian.fisheye.activity.ActivityItemList;
import com.atlassian.fisheye.activity.ActivityItemManager;
import com.atlassian.fisheye.activity.ActivityItemProvider;
import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.atlassian.fisheye.activity.ActivityItemSearchUtil;
import com.atlassian.fisheye.activity.ActivitySearchMonitor;
import com.atlassian.fisheye.search.SearchSortOrder;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.util.SortedList;
import com.cenqua.fisheye.util.Timer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="defaultActivityItemManager")
public class DefaultActivityItemManager
implements ActivityItemManager {
    private final ActivityItemProvider[] providers;

    @Autowired
    public DefaultActivityItemManager(ActivityItemProvider[] providers) {
        Arrays.sort(providers, ActivityItemProvider.QUERY_ORDER_COMPARATOR);
        this.providers = providers;
    }

    @Override
    public ActivityItemList findActivityItems(ActivityItemSearchParams params, Principal user, ActivitySearchMonitor activitySearchMonitor) {
        Comparator itemComparator = params.getSearchDirection() == SearchSortOrder.TOWARDS_PAST ? ActivityItemComparators.desc() : ActivityItemComparators.asc();
        SortedList<ActivityItem> items = new SortedList<ActivityItem>(itemComparator);
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        HashMap<ApplicationLink, Exception> applinkExceptions = new HashMap<ApplicationLink, Exception>();
        Timer t2 = new Timer("Querying " + this.providers.length + " providers");
        for (ActivityItemProvider provider : this.providers) {
            if (!provider.isApplicable(params)) continue;
            t2.mark("start " + provider.getClass().getSimpleName());
            ActivityItemList result = provider.findActivityItems(params, user, activitySearchMonitor);
            t2.mark("end " + provider.getClass().getSimpleName());
            exceptions.addAll(result.getExceptions());
            applinkExceptions.putAll(result.getApplinkExceptions());
            items.addAll((Collection<ActivityItem>)result.getItems());
            ActivityItemSearchUtil.trimToSize(items, params.getMaxItems());
            params = ActivityItemSearchUtil.optimiseParams(items, params);
        }
        t2.end();
        return new ActivityItemList(items, exceptions, applinkExceptions);
    }
}

