/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.activity;

import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.atlassian.fisheye.activity.RssFeedUrlBuilder;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.util.JiraServerUtil;
import com.cenqua.fisheye.web.FishEyePathInfo;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

public class ActivityStreamTabViewParams {
    private boolean enableJiraTab;
    private final boolean includeUser;
    private boolean RSS = false;
    private String RSSFeedUrl = "";

    public static ActivityStreamTabViewParams create(HttpServletRequest request, int itemsPerPage, String view, ActivityItemSearchParams params, boolean rss) throws ServletException {
        ActivityStreamTabViewParams tabViewParams = new ActivityStreamTabViewParams(params.isApplicableForExternals(), params.includeUserInDownstream());
        tabViewParams.setRSS(rss);
        tabViewParams.setRSSFeedUrl(ActivityStreamTabViewParams.createFeedUrl(request, itemsPerPage, params, view));
        return tabViewParams;
    }

    private static String createFeedUrl(HttpServletRequest request, int itemsPerPage, ActivityItemSearchParams params, String view) throws ServletException {
        try {
            String servletPath = (String)request.getAttribute("javax.servlet.forward.servlet_path");
            if (servletPath == null) {
                servletPath = request.getServletPath();
            }
            String pathInfo = request.getPathInfo() == null ? "" : request.getPathInfo();
            String baseurl = servletPath + pathInfo;
            FishEyePathInfo pi = null;
            if (params.getChangelogExplorer() != null) {
                pi = new FishEyePathInfo(request);
                baseurl = "/changelog";
            }
            RssFeedUrlBuilder builder = new RssFeedUrlBuilder(request, baseurl);
            builder.addRssQueryParameters(request.getParameterMap());
            builder.setMaxItems(itemsPerPage);
            builder.setPathInfo(pi);
            builder.setView(view);
            return builder.build().toString();
        }
        catch (DbException e2) {
            throw new ServletException((Throwable)e2);
        }
    }

    private ActivityStreamTabViewParams(boolean enableJiraTab, boolean includeUser) {
        this.enableJiraTab = enableJiraTab;
        this.includeUser = includeUser;
    }

    public boolean isRSS() {
        return this.RSS;
    }

    public boolean isShowJiraTab() {
        return this.isJiraOn();
    }

    public boolean isEnableJiraTab() {
        return this.enableJiraTab;
    }

    public void setRSS(boolean RSS) {
        this.RSS = RSS;
    }

    public String getRSSFeedUrl() {
        return this.RSSFeedUrl;
    }

    public void setRSSFeedUrl(String RSSFeedUrl) {
        this.RSSFeedUrl = RSSFeedUrl;
    }

    public boolean isAllOn() {
        return this.isJiraOn() || this.isCrucibleOn();
    }

    public boolean isJiraOn() {
        return JiraServerUtil.isJiraActivityAvailable();
    }

    public boolean isCrucibleOn() {
        return AppConfig.isCrucible();
    }

    public boolean isIncludeUser() {
        return this.includeUser;
    }

    public String getFocusTab() {
        return this.isAllOn() ? "all" : "fe";
    }
}

