/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.activity;

import com.cenqua.fisheye.web.ServletUtils;
import com.cenqua.fisheye.web.util.FishEyeURLEncoder;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class ActivityStreamHandlerPagingParams {
    private static final Pattern PREFKEY = Pattern.compile("^@[\\w\\d]+");
    private final Map<String, String[]> thisPageParams;
    private final Map<String, String[]> prevPageParams;
    private final Map<String, String[]> nextPageParams;
    private final String view;

    public ActivityStreamHandlerPagingParams(Map<String, String[]> prevPageParams, Map<String, String[]> nextPageParams, String view, Map<String, String[]> thisPageParams) {
        this.prevPageParams = prevPageParams;
        this.nextPageParams = nextPageParams;
        this.thisPageParams = thisPageParams == null ? new HashMap<String, String[]>() : thisPageParams;
        this.view = Strings.isNullOrEmpty((String)view) ? "all" : view;
        this.removeUserPreferenceParams(thisPageParams, prevPageParams, nextPageParams);
    }

    private void removeUserPreferenceParams(Map<String, String[]> ... paramsArray) {
        for (Map<String, String[]> params : paramsArray) {
            if (params == null) continue;
            ArrayList<String> entriesToRemove = new ArrayList<String>(params.size());
            for (String entry : params.keySet()) {
                if (!PREFKEY.matcher(entry).matches()) continue;
                entriesToRemove.add(entry);
            }
            for (String entry : entriesToRemove) {
                params.remove(entry);
            }
        }
    }

    private Map<String, String[]> getNonRSSParams() {
        HashMap<String, String[]> params = new HashMap<String, String[]>(this.thisPageParams);
        params.remove("RSS");
        return Collections.unmodifiableMap(params);
    }

    public String getThisPageParamsQueryString() {
        return ServletUtils.toQueryString(this.getNonRSSParams());
    }

    public String getThisPageParamsViewQueryString() {
        return this.toViewQueryString(this.getNonRSSParams());
    }

    public String getPrevPageParamsQueryString() {
        return ServletUtils.toQueryString(this.prevPageParams);
    }

    public String getNextPageParamsQueryString() {
        return ServletUtils.toQueryString(this.nextPageParams);
    }

    public String getPrevPageParamsViewQueryString() {
        return this.toViewQueryString(this.prevPageParams);
    }

    public String getNextPageParamsViewQueryString() {
        return this.toViewQueryString(this.nextPageParams);
    }

    public String getView() {
        return this.view;
    }

    private String toViewQueryString(Map<String, String[]> params) {
        StringBuilder query = new StringBuilder(ServletUtils.toQueryString(params));
        if (query.length() == 0) {
            query.append('?');
        } else {
            query.append('&');
        }
        query.append("view").append('=').append(FishEyeURLEncoder.uriEncode(this.view));
        return query.toString();
    }
}

