/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.activity;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.crucible.spi.services.GlobalPermissionService;
import com.atlassian.fecru.applinks.CredentialsRequiredMessage;
import com.atlassian.fecru.applinks.RemoteErrorMessage;
import com.atlassian.fisheye.activity.ActivityItem;
import com.atlassian.fisheye.activity.ActivityItemList;
import com.atlassian.fisheye.activity.ActivityItemManager;
import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.atlassian.fisheye.activity.ActivitySearchMonitor;
import com.atlassian.fisheye.activity.ActivityStreamHandlerPagingParams;
import com.atlassian.fisheye.activity.ActivityStreamShowChangeSetParams;
import com.atlassian.fisheye.activity.ActivityStreamTabViewParams;
import com.atlassian.fisheye.search.SearchSortOrder;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.tags.ProjectUtil;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.util.DateHelper;
import com.cenqua.fisheye.web.ChangeSetHolder;
import com.cenqua.fisheye.web.FishEyePathInfo;
import com.cenqua.fisheye.web.PreferenceManager;
import com.cenqua.fisheye.web.ServletUtils;
import com.cenqua.fisheye.web.WaybackSpec;
import com.cenqua.fisheye.web.changeset.ChangeSetDirTreeData;
import com.cenqua.fisheye.web.changeset.ChangeSetPageData;
import com.cenqua.fisheye.web.parameterbeans.ChangesetJspParams;
import com.cenqua.fisheye.web.util.ParamUtils;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ActivityStreamHandler {
    private static final String EXPAND = "expand";
    public static final int MAX_ITEMS_LIMIT = 10000;
    public static final String CHANGESET_PAGE_DATA = "changesetPage";
    private final String dispatchTo;
    private final String dispatchRSSTo;
    private final String dispatchAjaxTo;
    private final boolean shouldHandleNoResults;
    private boolean shouldRenderJsp;
    private ActivityItemList itemList;
    private ActivityStreamHandlerPagingParams pagingParams;
    private ActivityStreamTabViewParams tabViewParams;
    private boolean expand;
    private ActivitySearchMonitor activitySearchMonitor;
    private final GlobalPermissionService globalPermissionService;
    private RepositoryManager repositoryManager;
    private CommitterUserMappingManager commmitterUserMappingManager;

    public ActivityStreamHandler(GlobalPermissionService globalPermissionService, RepositoryManager repositoryManager, ActivitySearchMonitor activitySearchMonitor, CommitterUserMappingManager commmitterUserMappingManager) {
        this(globalPermissionService, repositoryManager, "/WEB-INF/jsp/activitystream.jsp", "/WEB-INF/jsp/activityStreamRSS.jsp", "/WEB-INF/jsp/activitystreamAjax.jsp", true, true, activitySearchMonitor, commmitterUserMappingManager);
    }

    public ActivityStreamHandler(GlobalPermissionService globalPermissionService, RepositoryManager repositoryManager, String dispatchTo, String dispatchRSSTo, String dispatchAjaxTo, boolean shouldHandleNoResults, boolean shouldRenderJsp, CommitterUserMappingManager commmitterUserMappingManager) {
        this(globalPermissionService, repositoryManager, dispatchTo, dispatchRSSTo, dispatchAjaxTo, shouldHandleNoResults, shouldRenderJsp, new ActivitySearchMonitor(), commmitterUserMappingManager);
    }

    public ActivityStreamHandler(GlobalPermissionService globalPermissionService, RepositoryManager repositoryManager, String dispatchTo, String dispatchRSSTo, String dispatchAjaxTo, boolean shouldHandleNoResults, boolean shouldRenderJsp, ActivitySearchMonitor activitySearchMonitor, CommitterUserMappingManager commmitterUserMappingManager) {
        this.globalPermissionService = globalPermissionService;
        this.repositoryManager = repositoryManager;
        this.dispatchTo = dispatchTo;
        this.dispatchRSSTo = dispatchRSSTo;
        this.dispatchAjaxTo = dispatchAjaxTo;
        this.shouldHandleNoResults = shouldHandleNoResults;
        this.shouldRenderJsp = shouldRenderJsp;
        this.activitySearchMonitor = activitySearchMonitor;
        this.commmitterUserMappingManager = commmitterUserMappingManager;
    }

    public void handleActivityStream(HttpServletRequest request, HttpServletResponse response, ActivityItemSearchParams params, Principal user, int itemsPerPage, String view, boolean isShowIdMode) throws IOException, ServletException {
        if (user == null) {
            user = Principal.Anonymous.ANON;
        }
        Map<String, String[]> cleanedParams = ServletUtils.copyParameterMap(request.getParameterMap());
        this.stripPagingParams(cleanedParams);
        if (params.getChangeset() != null) {
            this.renderSingleChangeset(request, response, params.getChangeset(), params, user, cleanedParams);
            return;
        }
        boolean toFuture = params.getSearchDirection() == SearchSortOrder.TOWARDS_FUTURE;
        ActivityItemManager activityItemManager = this.getActivityManager(params);
        String prevAnchor = request.getParameter("prevPageAnchor");
        String nextAnchor = request.getParameter("nextPageAnchor");
        if (params.getMaxItems() == 0) {
            this.itemList = new ActivityItemList(new ArrayList());
        } else if (toFuture && nextAnchor != null) {
            this.itemList = ActivityStreamHandler.getEnoughItemsForFuture(params, activityItemManager, nextAnchor, user, params.getMaxItems(), this.activitySearchMonitor);
        } else if (prevAnchor != null) {
            this.itemList = ActivityStreamHandler.getEnoughItemsForPast(params, activityItemManager, prevAnchor, user, params.getMaxItems(), this.activitySearchMonitor);
        } else if (nextAnchor == null && request.getParameter("maxDate") != null) {
            ActivityItemSearchParams.Builder paramsForward = ActivityItemSearchParams.Builder.fromParams(params);
            paramsForward.searchDirection(SearchSortOrder.TOWARDS_FUTURE).minDate(params.getMaxDate()).maxDate(null).build();
            List<ActivityItem> previtems = ActivityStreamHandler.getEnoughItemsForFuture(paramsForward.build(), activityItemManager, nextAnchor, user, 1, this.activitySearchMonitor).getItems();
            if (!previtems.isEmpty()) {
                prevAnchor = previtems.get(0).getOpaqueId();
                this.itemList = ActivityStreamHandler.getEnoughItemsForPast(params, activityItemManager, prevAnchor, user, params.getMaxItems(), this.activitySearchMonitor);
            } else {
                this.itemList = activityItemManager.findActivityItems(params, user, this.activitySearchMonitor);
            }
        } else {
            this.itemList = activityItemManager.findActivityItems(params, user, this.activitySearchMonitor);
        }
        if (isShowIdMode && params.isRepConstrained()) {
            String showId = request.getParameter("showid");
            if (showId == null) {
                showId = request.getParameter("jumptoid");
            }
            String repName = params.getRepFilter();
            RepositoryHandle repHandle = this.repositoryManager.getRepository(params.getRepFilter());
            boolean changeSetExists = false;
            try {
                RepositoryEngine engine;
                RepositoryEngine repositoryEngine = engine = repHandle == null ? null : repHandle.acquireEngine();
                if (engine != null) {
                    changeSetExists = engine.getRevisionCache().existsChangeSet(showId);
                }
            }
            catch (RepositoryHandle.StateException engine) {
            }
            catch (DbException e2) {
                Logs.APP_LOG.error((Object)"Error checking for existence of changeset", (Throwable)e2);
            }
            boolean showIdChangeSetPossiblyFiltered = false;
            if (changeSetExists) {
                boolean hasFilter = params.isFESpecific() || !params.getChangelogExplorer().getPath().isRoot();
                List<ActivityItem> changeSetHolders = this.itemList.getItems();
                if (changeSetHolders.size() == 0) {
                    showIdChangeSetPossiblyFiltered = hasFilter;
                } else {
                    int expectedIndex = params.getSearchDirection() == SearchSortOrder.TOWARDS_PAST ? 0 : changeSetHolders.size() - 1;
                    ChangeSetHolder changeSetHolder = (ChangeSetHolder)changeSetHolders.get(expectedIndex);
                    showIdChangeSetPossiblyFiltered = hasFilter && !changeSetHolder.getChangeset().getId().startsWith(showId);
                }
            }
            request.setAttribute("showChangeSetParams", (Object)new ActivityStreamShowChangeSetParams(repName, showId, changeSetExists, repHandle != null && !repHandle.getStatus().isInitialCrucibleIndexingComplete(), showIdChangeSetPossiblyFiltered));
        }
        boolean timedOut = this.activitySearchMonitor.isSearchTruncated();
        for (Exception e3 : this.itemList.getExceptions()) {
            Logs.APP_LOG.warn((Object)"Exception encountered while retrieving activity items: ", (Throwable)e3);
        }
        ArrayList<Object> credentialsMessages = new ArrayList<Object>();
        ArrayList<RemoteErrorMessage> remoteMessages = new ArrayList<RemoteErrorMessage>();
        for (Map.Entry<ApplicationLink, Exception> entry : this.itemList.getApplinkExceptions().entrySet()) {
            Object msg;
            Exception e4 = entry.getValue();
            if (e4 instanceof CredentialsRequiredException) {
                msg = new CredentialsRequiredMessage(entry.getKey(), e4.getMessage(), ((CredentialsRequiredException)((Object)e4)).getAuthorisationURI());
                credentialsMessages.add(msg);
                continue;
            }
            msg = new RemoteErrorMessage(entry.getKey(), e4.getMessage());
            remoteMessages.add((RemoteErrorMessage)msg);
            Logs.APP_LOG.warn((Object)"Exception encountered while retrieving activity items: ", (Throwable)e4);
        }
        request.setAttribute("credentialsRequired", credentialsMessages);
        request.setAttribute("remoteErrors", remoteMessages);
        this.expand = PreferenceManager.getPreferences(request).isAlwaysExpandChangesets();
        request.setAttribute("activityItems", this.itemList.getItems());
        request.setAttribute(EXPAND, (Object)this.expand);
        if (this.itemList.getItems().isEmpty() && this.handleNoResults(request, response, toFuture, cleanedParams, view, params)) {
            return;
        }
        if (!this.itemList.getItems().isEmpty()) {
            this.pagingParams = this.handlePaging(request, itemsPerPage, this.itemList, cleanedParams, view, isShowIdMode);
            this.tabViewParams = ActivityStreamTabViewParams.create(request, itemsPerPage, view, params, "true".equals(request.getParameter("RSS")));
            this.putPagingParams(request, this.pagingParams, this.tabViewParams);
        }
        if (this.tabViewParams.isRSS()) {
            request.setAttribute("activityStreamHandler", (Object)this);
        }
        if (this.shouldRenderJsp) {
            this.renderJsp(request, response);
        }
        this.activitySearchMonitor.setSearchTruncated(timedOut);
    }

    static ActivityItemList getEnoughItemsForFuture(ActivityItemSearchParams params, ActivityItemManager manager, String anchor, Principal user, int actualMax, ActivitySearchMonitor activitySearchMonitor) {
        boolean sizeChanged;
        List<ActivityItem> itemList;
        ActivityItemSearchParams.Builder extendedParamBuilder = ActivityStreamHandler.extendParams(params);
        int lastSize = 0;
        int numSearched = 0;
        do {
            int index;
            ActivityItemSearchParams itemSearchParams;
            if ((itemSearchParams = extendedParamBuilder.build()).getMaxItems() > 10000) {
                extendedParamBuilder.maxItems(Math.min(actualMax, 10000));
                return manager.findActivityItems(extendedParamBuilder.build(), user, activitySearchMonitor);
            }
            ActivityItemList items = manager.findActivityItems(itemSearchParams, user, activitySearchMonitor).reverse();
            itemList = items.getItems();
            if (itemList.isEmpty()) break;
            sizeChanged = lastSize != itemList.size();
            int searchStart = itemList.size() - numSearched;
            for (index = searchStart - 1; index >= 0; --index) {
                ActivityItem item = itemList.get(index);
                if (anchor == null && !item.getDate().equals(params.getMinDate()) || anchor != null && item.getOpaqueId().equals(anchor)) break;
                numSearched = itemList.size() - index;
            }
            lastSize = itemList.size();
            itemList = index >= 0 ? itemList.subList(0, index) : Collections.emptyList();
            extendedParamBuilder.maxItems(3 * itemSearchParams.getMaxItems());
        } while (itemList.size() < actualMax && sizeChanged && !activitySearchMonitor.isTimeExceeded());
        if (itemList.size() > actualMax) {
            itemList = itemList.subList(itemList.size() - actualMax, itemList.size());
        }
        return new ActivityItemList(itemList);
    }

    private static ActivityItemSearchParams.Builder extendParams(ActivityItemSearchParams params) {
        ActivityItemSearchParams.Builder extendedParamBuilder = ActivityItemSearchParams.Builder.fromParams(params);
        int extendedMaxItems = (int)Math.ceil((double)params.getMaxItems() * 1.15);
        extendedParamBuilder.maxItems(extendedMaxItems);
        return extendedParamBuilder;
    }

    static ActivityItemList getEnoughItemsForPast(ActivityItemSearchParams params, ActivityItemManager manager, String anchor, Principal user, int actualMax, ActivitySearchMonitor activitySearchMonitor) {
        boolean sizeChanged;
        List<ActivityItem> itemList;
        ActivityItemSearchParams.Builder extendedParamBuilder = ActivityStreamHandler.extendParams(params);
        int lastSize = 0;
        int searchStart = 0;
        do {
            int index;
            ActivityItemSearchParams itemSearchParams;
            if ((itemSearchParams = extendedParamBuilder.build()).getMaxItems() > 10000) {
                extendedParamBuilder.maxItems(Math.min(actualMax, 10000));
                return manager.findActivityItems(extendedParamBuilder.build(), user, activitySearchMonitor);
            }
            ActivityItemList items = manager.findActivityItems(itemSearchParams, user, activitySearchMonitor);
            itemList = items.getItems();
            if (itemList.isEmpty()) break;
            sizeChanged = lastSize != itemList.size();
            for (index = searchStart; index < itemList.size(); ++index) {
                ActivityItem item = itemList.get(index);
                if (anchor == null && !item.getDate().equals(params.getMinDate()) || anchor != null && item.getOpaqueId().equals(anchor)) break;
                searchStart = index + 1;
            }
            lastSize = itemList.size();
            itemList = index < itemList.size() ? itemList.subList(index + 1, itemList.size()) : Collections.emptyList();
            extendedParamBuilder.maxItems(3 * itemSearchParams.getMaxItems());
        } while (itemList.size() < actualMax && sizeChanged && !activitySearchMonitor.isTimeExceeded());
        if (itemList.size() > actualMax) {
            itemList = itemList.subList(0, actualMax);
        }
        return new ActivityItemList(itemList);
    }

    private ActivityItemManager getActivityManager(ActivityItemSearchParams params) {
        return SpringContext.getComponent(ActivityItemManager.class, params.isDownStream() ? "starDownStreamActivityItemManager" : "defaultActivityItemManager");
    }

    public static ActivityItemSearchParams constructGeneralSearchParams(HttpServletRequest request, int itemsPerPage, TimeZone tz, String view) {
        ActivityItemSearchParams.Builder paramBuilder = new ActivityItemSearchParams.Builder();
        if (view == null || view.equals("all")) {
            paramBuilder.includeFisheye().includeCrucible();
            if (FishEyeSysProps.JIRA_ACTIVITY_ENABLED) {
                paramBuilder.includeExternals();
            }
        } else if (view.equals("fe")) {
            paramBuilder.includeFisheye();
        } else if (view.equals("cru")) {
            paramBuilder.includeCrucible();
        } else if (FishEyeSysProps.JIRA_ACTIVITY_ENABLED && view.equals("jira")) {
            paramBuilder.includeExternals();
        } else {
            Logs.APP_LOG.debug((Object)"Activity stream accessed with JIRA activity cookie, but JIRA activity is disabled globally. Defaulting to Commits and Review activity");
            paramBuilder.includeFisheye().includeCrucible();
        }
        String searchDirectionName = request.getParameter("direction");
        if (request.getParameter("star") != null) {
            paramBuilder.downstream();
        }
        if ("future".equals(searchDirectionName)) {
            paramBuilder.searchDirection(SearchSortOrder.TOWARDS_FUTURE);
        } else {
            paramBuilder.searchDirection(SearchSortOrder.TOWARDS_PAST);
        }
        Long minDate = ServletUtils.parseLongFromRequest("minDate", request);
        if (minDate != null) {
            paramBuilder.minDate(new Date(minDate));
        } else {
            Long maxDate = ServletUtils.parseLongFromRequest("maxDate", request);
            if (maxDate != null) {
                paramBuilder.maxDate(new Date(maxDate));
            }
        }
        paramBuilder.timeZone(tz);
        paramBuilder.maxItems(itemsPerPage);
        return paramBuilder.build();
    }

    public static ActivityItemSearchParams constructSearchParams(HttpServletRequest request, int itemsPerPage, TimeZone tz, String view) {
        String csid;
        String projectKey;
        String committer;
        String userName;
        ActivityItemSearchParams.Builder paramBuilder = ActivityItemSearchParams.Builder.fromParams(ActivityStreamHandler.constructGeneralSearchParams(request, itemsPerPage, tz, view));
        FishEyePathInfo pi = new FishEyePathInfo(request);
        String repname = request.getParameter("repname");
        if (repname == null) {
            repname = pi.getRepname();
        }
        String p2 = request.getParameter("p");
        if (pi.isEmpty()) {
            if (p2 != null && !Strings.isNullOrEmpty((String)repname)) {
                paramBuilder.path(repname, new Path(p2));
            }
        } else {
            paramBuilder.path(pi.getRepname(), pi.getLocalPath());
        }
        if (PreferenceManager.getPreferences(request).isIncludeUserOnHome()) {
            paramBuilder.includeUserInDownStream();
        }
        if (!Strings.isNullOrEmpty((String)(userName = request.getParameter("username")))) {
            paramBuilder.user(userName);
        }
        if (!Strings.isNullOrEmpty((String)(committer = request.getParameter("committer"))) && !Strings.isNullOrEmpty((String)repname)) {
            paramBuilder.anyCommitter(repname, committer);
        }
        if (!Strings.isNullOrEmpty((String)(projectKey = request.getParameter("project")))) {
            paramBuilder.crossRepositoryConstraint(ProjectUtil.generateRepositoryConstraint(projectKey));
        }
        if (!Strings.isNullOrEmpty((String)(csid = request.getParameter("cs")))) {
            if (csid.matches("//[^/]+/[^/]+")) {
                String[] s2 = csid.split("/");
                paramBuilder.changeset(s2[2], s2[3]);
            } else if (!Strings.isNullOrEmpty((String)repname)) {
                paramBuilder.changeset(repname, csid);
            }
        }
        return ActivityStreamHandler.fromCommandString(paramBuilder, pi);
    }

    public static ActivityItemSearchParams fromCommandString(ActivityItemSearchParams.Builder paramBuilder, FishEyePathInfo pi) {
        ActivityItemSearchParams current = paramBuilder.build();
        WaybackSpec wb = WaybackSpec.fromCommandString(pi.getCommandString());
        if (pi.getCommandString() == null) {
            return paramBuilder.build();
        }
        if (!current.isRepConstrained()) {
            paramBuilder.path(pi.getRepname(), pi.getLocalPath());
        }
        if (wb != null) {
            String endDate;
            paramBuilder.setWbFilter(wb);
            String startDate = wb.getStartDateStr();
            if (!Strings.isNullOrEmpty((String)startDate)) {
                paramBuilder.minDateString(startDate);
                long now = System.currentTimeMillis();
                TimeZone tz = AppConfig.getsConfig().getTimezone();
                Long startTime = DateHelper.parseDate(startDate, now, tz);
                if (startTime != null && current.getMinDate() == null) {
                    paramBuilder.minDate(new Date(startTime));
                } else if (startTime != null && startTime > current.getMinDate().getTime()) {
                    paramBuilder.minDate(new Date(startTime));
                }
            }
            if (Strings.isNullOrEmpty((String)(endDate = wb.getEndDateStr()))) {
                endDate = wb.getDateStr();
            }
            if (!Strings.isNullOrEmpty((String)endDate)) {
                paramBuilder.maxDateString(endDate);
                long now = System.currentTimeMillis();
                TimeZone tz = AppConfig.getsConfig().getTimezone();
                Long endTime = DateHelper.parseDate(endDate, now, tz);
                if (endTime != null && current.getMaxDate() == null) {
                    paramBuilder.maxDate(new Date(endTime));
                } else if (endTime != null && endTime < current.getMaxDate().getTime()) {
                    paramBuilder.maxDate(new Date(endTime));
                }
            }
        }
        return paramBuilder.build();
    }

    private boolean handleNoResults(HttpServletRequest request, HttpServletResponse response, boolean toFuture, Map<String, String[]> cleanedParams, String view, ActivityItemSearchParams itemParams) throws ServletException, IOException {
        if ("false".equals(request.getParameter("redirect")) || !this.shouldHandleNoResults) {
            request.setAttribute("activityItems", Collections.emptyList());
            this.pagingParams = new ActivityStreamHandlerPagingParams(Collections.emptyMap(), Collections.emptyMap(), view, (Map)request.getAttribute("pagingParams"));
            this.tabViewParams = ActivityStreamTabViewParams.create(request, itemParams.getMaxItems(), view, itemParams, "true".equals(request.getParameter("RSS")));
            if (this.tabViewParams.isRSS()) {
                request.setAttribute("activityStreamHandler", (Object)this);
            }
            this.putPagingParams(request, this.pagingParams, this.tabViewParams);
            if (this.shouldRenderJsp) {
                this.renderJsp(request, response);
            }
            return true;
        }
        if (toFuture) {
            cleanedParams.put("redirect", new String[]{"false"});
            cleanedParams.put("view", new String[]{view});
            response.sendRedirect(request.getContextPath() + "/changelog" + ServletUtils.toQueryString(cleanedParams));
            return true;
        }
        Long rMinDate = ServletUtils.parseLongFromRequest("minDate", request);
        if (rMinDate != null) {
            cleanedParams.put("minDate", new String[]{rMinDate.toString()});
        }
        cleanedParams.put("direction", new String[]{"future"});
        cleanedParams.put("view", new String[]{view});
        response.sendRedirect(request.getContextPath() + "/changelog" + ServletUtils.toQueryString(cleanedParams));
        return true;
    }

    private ActivityStreamHandlerPagingParams handlePaging(HttpServletRequest request, int itemsPerPage, ActivityItemList itemList, Map<String, String[]> cleanedParams, String view, boolean isShowIdMode) {
        cleanedParams.put("max", new String[]{String.valueOf(itemsPerPage)});
        Map<String, String[]> thisPageParams = ServletUtils.copyParameterMap(cleanedParams);
        this.addParamIfExists(request, "minDate", thisPageParams);
        this.addParamIfExists(request, "direction", thisPageParams);
        this.addParamIfExists(request, "maxDate", thisPageParams);
        this.addParamIfExists(request, "nextPageAnchor", thisPageParams);
        this.addParamIfExists(request, "prevPageAnchor", thisPageParams);
        Map<String, String[]> prevPageParams = ServletUtils.copyParameterMap(cleanedParams);
        prevPageParams.put("maxDate", new String[]{String.valueOf(itemList.lastItem().getDate().getTime())});
        prevPageParams.put("prevPageAnchor", new String[]{itemList.lastItem().getOpaqueId()});
        Map<String, String[]> nextPageParams = ServletUtils.copyParameterMap(cleanedParams);
        nextPageParams.put("minDate", new String[]{String.valueOf(itemList.firstItem().getDate().getTime())});
        nextPageParams.put("direction", new String[]{"future"});
        nextPageParams.put("nextPageAnchor", new String[]{itemList.firstItem().getOpaqueId()});
        if (isShowIdMode) {
            thisPageParams.put("maxDate", new String[]{String.valueOf(itemList.firstItem().getDate().getTime())});
        }
        return new ActivityStreamHandlerPagingParams(prevPageParams, nextPageParams, view, thisPageParams);
    }

    private void addParamIfExists(HttpServletRequest request, String name, Map<String, String[]> params) {
        String param = request.getParameter(name);
        if (param != null) {
            params.put(name, new String[]{param});
        }
    }

    private void putPagingParams(HttpServletRequest request, ActivityStreamHandlerPagingParams params, ActivityStreamTabViewParams tabParams) {
        request.setAttribute("pagingParams", (Object)params);
        request.setAttribute("tabParams", (Object)tabParams);
    }

    private void renderJsp(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if ("true".equals(request.getParameter("activityAjax"))) {
            request.getRequestDispatcher(this.dispatchAjaxTo).forward((ServletRequest)request, (ServletResponse)response);
        } else if ("true".equals(request.getParameter("RSS"))) {
            request.getRequestDispatcher(this.dispatchRSSTo).forward((ServletRequest)request, (ServletResponse)response);
        } else {
            request.getRequestDispatcher(this.dispatchTo).forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    private void stripPagingParams(Map<String, String[]> params) {
        params.remove("max");
        params.remove("cs");
        params.remove("max");
        params.remove("minDate");
        params.remove("maxDate");
        params.remove("prevPageAnchor");
        params.remove("nextPageAnchor");
        params.remove("direction");
        params.remove("redirect");
        params.remove("view");
        params.remove("type");
        params.remove("showid");
    }

    private void renderSingleChangeset(HttpServletRequest request, HttpServletResponse response, ActivityItemSearchParams.ChangeSetRef csRef, ActivityItemSearchParams params, Principal user, Map<String, String[]> cleanedParams) throws IOException, ServletException {
        List<String> partialIds;
        Object cs;
        RevisionCache<? extends ChangeSet> revCache;
        RepositoryHandle rep = AppConfig.getsConfig().getRepositoryManager().getRepository(csRef.getRepName());
        try {
            RepositoryEngine eng = rep.acquireEngine();
            revCache = eng.getRevisionCache();
            cs = revCache.getChangeSet(csRef.getCsid());
        }
        catch (RepositoryHandle.StateException e2) {
            ServletUtils.sendRepositoryNotRunning(request, response, rep);
            return;
        }
        ChangesetJspParams jspParams = new ChangesetJspParams(csRef.getRepName(), PreferenceManager.getPreferences(request), csRef, this.globalPermissionService.hasUserPermissions(user, Collections.singleton(GlobalPermissionType.CRUCIBLE_USER)));
        if (cs == null && !(partialIds = revCache.findSimilarPartialChangeSetIds(csRef.getCsid())).isEmpty()) {
            jspParams.setPartialMatch(true);
            ArrayList<ChangeSet> partialChangesets = new ArrayList<ChangeSet>(partialIds.size());
            Iterator<String> iterator = partialIds.iterator();
            while (iterator.hasNext()) {
                String partialId;
                String id = partialId = iterator.next();
                partialChangesets.add((ChangeSet)revCache.getChangeSet(id));
            }
            if (partialChangesets.size() == 1) {
                cs = (ChangeSet)partialChangesets.get(0);
            } else {
                jspParams.setPartialChangeSetMatches(partialChangesets);
            }
        }
        if (cs != null) {
            List<String> similarIds = revCache.getSimilarChangeSetIds(cs.getId());
            if (similarIds.size() > 1) {
                jspParams.setSimilarChangeSetIds(similarIds);
            }
            jspParams.setNextChangeSet((ChangeSet)revCache.getNextChangeSet((ChangeSet)cs));
            jspParams.setPreviousChangeSet((ChangeSet)revCache.getPreviousChangeSet((ChangeSet)cs));
            String defaultBranch = revCache.getDefaultBranch();
            ChangeSetHolder.Context c2 = new ChangeSetHolder.Context(new WaybackSpec(), revCache.isCaseSensitive(), 5, params.getPaths().size() == 1 ? params.getPaths().get(0) : Path.ROOT, revCache.getRepositoryName(), revCache.getRepositoryType(), defaultBranch);
            jspParams.setChangeset(new ChangeSetHolder((ChangeSet)cs, c2, rep.getCfg().isSupportsBranchFilter(), this.commmitterUserMappingManager));
            jspParams.setWbSpec(c2.getWbSpec());
            try {
                ChangeSetPageData cspd = new ChangeSetPageData(new WaybackSpec(), (ChangeSet)cs, request.getParameter("revPagePath"), this.getParameterWithDefault(request, "pageNum", 1), this.getParameterWithDefault(request, "index", 0), revCache, PreferenceManager.getPreferences(request));
                request.setAttribute(CHANGESET_PAGE_DATA, (Object)cspd);
                request.setAttribute("directoryTree", (Object)new ChangeSetDirTreeData("", null, (ChangeSet)cs, cspd));
            }
            catch (DbException e3) {
                throw new RuntimeException("Error getting changeset data", e3);
            }
        }
        boolean isPathConstrained = params.getPaths().size() == 1;
        jspParams.setPathConstrained(isPathConstrained);
        jspParams.setFpath(isPathConstrained ? new Path(revCache.getRepositoryName(), params.getPaths().get(0)) : Path.ROOT);
        jspParams.setPath(isPathConstrained ? params.getPaths().get(0) : Path.ROOT);
        jspParams.setStreamQueryString(ServletUtils.toQueryString(cleanedParams));
        request.setAttribute("p", (Object)jspParams);
        if (this.shouldRenderJsp) {
            if (cs == null && (jspParams.getPartialChangeSetMatches() == null || jspParams.getPartialChangeSetMatches().size() == 0)) {
                request.getRequestDispatcher("/WEB-INF/jsp/nochangeset.jsp").forward((ServletRequest)request, (ServletResponse)response);
            } else {
                request.getRequestDispatcher("/WEB-INF/jsp/changeset.jsp").forward((ServletRequest)request, (ServletResponse)response);
            }
        }
    }

    private int getParameterWithDefault(HttpServletRequest request, String name, int defaultValue) {
        return ParamUtils.parseInt(request.getParameter(name), defaultValue);
    }

    private ChangeSetHolder findPrev(ActivityItemSearchParams params, Principal user, ChangeSet cs) {
        ActivityItemSearchParams.Builder prevCs = ActivityItemSearchParams.Builder.fromParams(params).searchDirection(SearchSortOrder.TOWARDS_PAST).minDate(null).excludeCrucible().excludeExternals().includeFisheye().maxDate(cs.getDateValue()).maxItems(5);
        return this.searchFromChangeset(prevCs, user, cs, false);
    }

    private ChangeSetHolder searchFromChangeset(ActivityItemSearchParams.Builder builder, Principal user, ChangeSet cs, boolean toFuture) {
        LinkedList list;
        ActivityItemManager manager = this.getActivityManager(builder.build());
        ActivityItem identicalResultsSentinel = null;
        int maxLoops = 10000;
        int loopCount = 0;
        boolean pastCurrentItem = false;
        do {
            if (loopCount++ > 10000) {
                Logs.APP_LOG.error((Object)("Performed 10000 searches without finding changeset " + (toFuture ? "after " : "before ") + cs.getId() + " - returning null."));
                return null;
            }
            ActivityItemSearchParams params = builder.build();
            list = Lists.newLinkedList(manager.findActivityItems(params, user, this.activitySearchMonitor).getItems());
            boolean outOfItems = list.size() < params.getMaxItems();
            boolean found = false;
            if (!list.isEmpty()) {
                ActivityItem lastElement = (ActivityItem)list.get(list.size() - 1);
                if (identicalResultsSentinel != null && identicalResultsSentinel.getOpaqueId().equals(lastElement.getOpaqueId())) {
                    builder.maxItems(builder.build().getMaxItems() + 5);
                } else {
                    identicalResultsSentinel = lastElement;
                }
            }
            if (toFuture) {
                Collections.reverse(list);
            }
            Iterator it = list.iterator();
            while (it.hasNext()) {
                ActivityItem item = (ActivityItem)it.next();
                if (!"changeset".equals(item.getType())) {
                    it.remove();
                    continue;
                }
                if (!pastCurrentItem) {
                    it.remove();
                    if (toFuture) {
                        builder.minDate(item.getDate());
                    } else {
                        builder.maxDate(item.getDate());
                    }
                } else {
                    found = true;
                }
                pastCurrentItem = pastCurrentItem || ((ChangeSetHolder)item).getChangeset().getId().equals(cs.getId());
            }
            if (found || !outOfItems) continue;
            return null;
        } while (list.isEmpty());
        return (ChangeSetHolder)list.get(0);
    }

    public ActivityStreamHandlerPagingParams getPagingParams() {
        return this.pagingParams;
    }

    public ActivityItemList getItemList() {
        return this.itemList;
    }

    public ActivityStreamTabViewParams getTabViewParams() {
        return this.tabViewParams;
    }

    public boolean isExpand() {
        return this.expand;
    }
}

