/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.activity;

import com.atlassian.fisheye.activity.ActivityRequestConstants;
import com.cenqua.fisheye.web.UrlHelper;
import javax.servlet.ServletRequest;

public class ActivitySearchMonitor {
    private final Long timeEnd;
    private boolean searchTruncated = false;
    private final Long timeoutDuration;

    public ActivitySearchMonitor() {
        this.timeEnd = null;
        this.timeoutDuration = null;
    }

    public ActivitySearchMonitor(Long timeout) {
        if (timeout != null && timeout > 0L) {
            this.timeEnd = System.currentTimeMillis() + timeout;
            this.timeoutDuration = timeout;
        } else {
            this.timeEnd = null;
            this.timeoutDuration = null;
        }
    }

    public void setSearchTruncated(boolean searchTruncated) {
        this.searchTruncated = searchTruncated;
    }

    public boolean isSearchTruncated() {
        return this.searchTruncated;
    }

    public boolean isTimeExceeded() {
        return this.timeEnd != null && System.currentTimeMillis() > this.timeEnd;
    }

    public Long getTimeoutDuration() {
        return this.timeoutDuration;
    }

    public static String getIncreatedTimeoutUrl(ServletRequest request, ActivitySearchMonitor activitySearchMonitor) {
        UrlHelper helper = new UrlHelper();
        helper.putParams(request.getParameterMap());
        if (activitySearchMonitor.getTimeoutDuration() == null) {
            helper.putParam("timeout", ActivityRequestConstants.DEFAULT_TIMEOUT_SHORT * 5);
        } else {
            helper.putParam("timeout", activitySearchMonitor.getTimeoutDuration() * 5L);
        }
        return helper.getParamString();
    }
}

