/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.activity;

import com.atlassian.fisheye.activity.ActivityItem;
import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.cenqua.fisheye.util.SortedList;
import java.util.List;

public class ActivityItemSearchUtil {
    public static ActivityItemSearchParams optimiseParams(List<ActivityItem> items, ActivityItemSearchParams params) {
        if (items.isEmpty() || items.size() < params.getMaxItems()) {
            return params;
        }
        ActivityItemSearchParams.Builder newParamsBuilder = ActivityItemSearchParams.Builder.fromParams(params);
        switch (params.getSearchDirection()) {
            case TOWARDS_PAST: {
                ActivityItem earliest = items.get(items.size() - 1);
                newParamsBuilder.minDate(earliest.getDate());
                break;
            }
            case TOWARDS_FUTURE: {
                ActivityItem latest = items.get(0);
                newParamsBuilder.maxDate(latest.getDate());
            }
        }
        return newParamsBuilder.build();
    }

    public static void trimToSize(SortedList<ActivityItem> items, int maxItems) {
        if (items.size() > maxItems) {
            items.remove(maxItems, items.size());
        }
    }
}

