/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.activity;

import com.atlassian.fisheye.activity.RepositoryConstraints;
import com.atlassian.fisheye.search.SearchSortOrder;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.tags.ProjectUtil;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RecentChangesParams2;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.web.FisheyeChangelogExplorer;
import com.cenqua.fisheye.web.WaybackSpec;
import com.google.common.base.Strings;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.lang.builder.ToStringBuilder;

public class ActivityItemSearchParams {
    private final boolean isDownStream;
    private final String repFilter;
    private final TimeZone tz;
    private final Date minDate;
    private final Date maxDate;
    private final SearchSortOrder searchSortOrder;
    private final int maxItems;
    private List<String> committers;
    private List<Path> paths;
    private String userFilter;
    private final IntSet reviewIds;
    private final Integer projectId;
    private final WaybackSpec wbFilter;
    private final String minDateString;
    private final String maxDateString;
    private final FisheyeChangelogExplorer changelogExplorer;
    private final boolean includeCruData;
    private final boolean includeFEData;
    private final boolean includeExternals;
    private final boolean includeUserInDownstream;
    private final ChangeSetRef changeset;
    private final RepositoryConstraints crossRepConstraints;
    private final String forcedAnchorAtLatest;

    private ActivityItemSearchParams(boolean downStream, String repFilter, TimeZone tz, Date minDate, Date maxDate, SearchSortOrder searchSortOrder, int maxItems, List<String> committers, List<Path> paths, String userFilter, IntSet reviewIds, Integer projectId, String minDateString, String maxDateString, FisheyeChangelogExplorer changelogExplorer, boolean includeCruData, boolean includeFEData, boolean includeExternals, RepositoryConstraints crossRepConstraints, boolean includeUserInDownstream, ChangeSetRef changeset, String forcedAnchorAtLatest, WaybackSpec wbFilter) {
        this.isDownStream = downStream;
        this.repFilter = repFilter;
        this.tz = tz;
        this.minDate = minDate;
        this.maxDate = maxDate;
        this.searchSortOrder = searchSortOrder;
        this.maxItems = maxItems;
        this.committers = committers;
        this.paths = paths;
        this.userFilter = userFilter;
        this.reviewIds = reviewIds;
        this.projectId = projectId;
        this.wbFilter = wbFilter;
        this.minDateString = minDateString;
        this.maxDateString = maxDateString;
        this.changelogExplorer = changelogExplorer;
        this.includeCruData = includeCruData;
        this.includeFEData = includeFEData;
        this.includeExternals = includeExternals;
        this.crossRepConstraints = crossRepConstraints;
        this.includeUserInDownstream = includeUserInDownstream;
        this.changeset = changeset;
        this.forcedAnchorAtLatest = forcedAnchorAtLatest;
    }

    public String forcedAnchorAtLatest() {
        return this.forcedAnchorAtLatest;
    }

    public String getCompulsoryCommitter() {
        return this.wbFilter.getAuthor();
    }

    public RepositoryConstraints getCrossRepConstraints() {
        return this.crossRepConstraints;
    }

    public String getBranch() {
        return this.wbFilter.getBranch();
    }

    public String getCommentSearchText() {
        return this.wbFilter.getCommentSearchText();
    }

    public String getFileExtension() {
        return this.wbFilter.getFileExtension();
    }

    public String getFileName() {
        return this.wbFilter.getFileName();
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public TimeZone getTz() {
        return this.tz;
    }

    public boolean isRepConstrained() {
        return !Strings.isNullOrEmpty((String)this.repFilter);
    }

    public Date getMinDate() {
        return this.minDate;
    }

    public Date getMaxDate() {
        return this.maxDate;
    }

    public SearchSortOrder getSearchDirection() {
        return this.searchSortOrder;
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    public String getRepFilter() {
        return this.repFilter;
    }

    public List<String> getCommitters() {
        return this.committers;
    }

    public List<Path> getPaths() {
        return this.paths;
    }

    public boolean isDownStream() {
        return this.isDownStream;
    }

    public String getUserFilter() {
        return this.userFilter;
    }

    public IntSet getReviewIds() {
        return this.reviewIds;
    }

    public String getMinDateString() {
        return this.minDateString;
    }

    public String getMaxDateString() {
        return this.maxDateString;
    }

    public FisheyeChangelogExplorer getChangelogExplorer() {
        return this.changelogExplorer;
    }

    public ChangeSetRef getChangeset() {
        return this.changeset;
    }

    public boolean useCruData() {
        return this.includeCruData;
    }

    public boolean useFEData() {
        return this.includeFEData;
    }

    public boolean useExternals() {
        return this.includeExternals;
    }

    public boolean isNotCommitterConstrained() {
        return this.committers.isEmpty() && this.getCompulsoryCommitter() == null;
    }

    public boolean isIncludeExternals() {
        return this.includeExternals;
    }

    public boolean includeUserInDownstream() {
        return this.includeUserInDownstream;
    }

    public RecentChangesParams2 generateChangelogParams(String rep) throws DbException {
        RecentChangesParams2 params = this.changelogExplorer != null ? this.changelogExplorer.generateParams() : new RecentChangesParams2();
        for (String string : this.committers) {
            params.addAnyCommiter(string);
        }
        for (Path path : this.paths) {
            params.addAnyPath(path);
        }
        if (this.crossRepConstraints != null && rep != null) {
            RepositoryConstraints.RepositoryConstraint item = this.crossRepConstraints.getConstraintsForRep(rep);
            if (item == null) {
                Logs.APP_LOG.warn((Object)("Repository constraints for " + rep + " was null"));
            } else {
                if (!item.isIncludeWholeRepository()) {
                    for (Path path : item.getPaths()) {
                        params.addAnyPath(path);
                    }
                }
                for (String committer : item.getCommitters()) {
                    params.addAnyCommiter(committer);
                }
            }
        }
        params.setWbFilter(this.wbFilter);
        if (!Strings.isNullOrEmpty((String)this.userFilter) && !Strings.isNullOrEmpty((String)this.repFilter)) {
            CommitterUserMappingManager manager = SpringContext.getComponentByClass(CommitterUserMappingManager.class);
            List<String> list = manager.getAllCommittersForUserInRep(this.repFilter, this.userFilter);
            for (String userCommitter : list) {
                params.addAnyCommiter(userCommitter);
            }
        }
        if (this.minDate != null) {
            params.setMinDate(this.minDate.getTime());
        }
        if (this.maxDate != null) {
            params.setMaxDate(this.maxDate.getTime());
        }
        params.setMaxReturn(this.maxItems);
        if (this.searchSortOrder == null) {
            params.setSearchDirection(0);
        } else {
            params.setSearchDirection(this.searchSortOrder == SearchSortOrder.TOWARDS_PAST ? 0 : 1);
        }
        return params;
    }

    public boolean isApplicableForExternals() {
        boolean applicable = true;
        if (this.paths.size() == 1) {
            applicable = this.paths.get(0).isRoot();
        } else if (this.paths.size() > 1) {
            applicable = false;
        }
        if (applicable) {
            applicable = !this.isFESpecificWithoutBranch();
        }
        return applicable;
    }

    public boolean isApplicableForCrucibleSearch() {
        return this.includeCruData;
    }

    private boolean isFESpecificWithoutBranch() {
        return this.getCompulsoryCommitter() != null || this.getFileExtension() != null || this.getFileName() != null || this.getCommentSearchText() != null || !this.committers.isEmpty();
    }

    public boolean isFESpecific() {
        return this.isFESpecificWithoutBranch() || this.getBranch() != null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static class ChangeSetRef {
        private String repName;
        private String csid;

        private ChangeSetRef(String repName, String csid) {
            this.repName = repName;
            this.csid = csid;
        }

        public String getRepName() {
            return this.repName;
        }

        public String getCsid() {
            return this.csid;
        }
    }

    public static class Builder {
        private Date minDate;
        private Date maxDate;
        private SearchSortOrder searchSortOrder;
        private int maxItems = -1;
        private String repFilter = null;
        private TimeZone tz;
        private List<String> committers = new ArrayList<String>();
        private List<Path> paths = new ArrayList<Path>();
        private String userFilter = null;
        private boolean isDownStream = false;
        private IntSet reviewIds = new IntOpenHashSet();
        private Integer projectId = null;
        private String minDateString;
        private String maxDateString;
        private FisheyeChangelogExplorer changelogExplorer;
        private boolean includeCruData = false;
        private boolean includeFEData = false;
        private boolean includeExternals = false;
        private RepositoryConstraints crossRepConstraints = null;
        private boolean includeUserInDownstream = false;
        private ChangeSetRef changeset = null;
        private String forcedAnchorAtLatest = null;
        private WaybackSpec wbFilter = new WaybackSpec();

        public static Builder fromParams(ActivityItemSearchParams params) {
            Builder b2 = new Builder();
            b2.minDate = params.getMinDate();
            b2.maxDate = params.getMaxDate();
            b2.searchSortOrder = params.getSearchDirection();
            b2.maxItems = params.getMaxItems();
            b2.repFilter = params.getRepFilter();
            b2.tz = params.getTz();
            b2.committers.addAll(params.getCommitters());
            b2.paths.addAll(params.getPaths());
            b2.isDownStream = params.isDownStream();
            b2.userFilter = params.getUserFilter();
            b2.reviewIds.addAll((IntCollection)params.getReviewIds());
            b2.projectId = params.getProjectId();
            b2.wbFilter = params.wbFilter;
            b2.minDateString = params.getMinDateString();
            b2.maxDateString = params.getMaxDateString();
            b2.changelogExplorer = params.getChangelogExplorer();
            b2.includeCruData = params.useCruData();
            b2.includeFEData = params.useFEData();
            b2.includeExternals = params.useExternals();
            b2.crossRepConstraints = params.crossRepConstraints;
            b2.includeUserInDownstream = params.includeUserInDownstream();
            b2.changeset = params.getChangeset();
            b2.forcedAnchorAtLatest = params.forcedAnchorAtLatest();
            return b2;
        }

        public Builder forcedAnchorAtLatest(String csid) {
            this.forcedAnchorAtLatest = csid;
            return this;
        }

        public Builder minDate(Date minDate) {
            this.minDate = minDate;
            return this;
        }

        public Builder maxDate(Date maxDate) {
            this.maxDate = maxDate;
            return this;
        }

        public Builder searchDirection(SearchSortOrder searchSortOrder) {
            this.searchSortOrder = searchSortOrder;
            return this;
        }

        public Builder maxItems(int maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public Builder paths(Set<Path> paths, String rep) {
            this.paths.addAll(paths);
            this.repFilter = rep;
            return this;
        }

        public Builder anyCommitters(Set<String> committers, String rep) {
            this.repFilter = rep;
            this.committers.addAll(committers);
            return this;
        }

        public Builder downstream() {
            this.isDownStream = true;
            return this;
        }

        public Builder project(Project project) {
            this.projectId = project.getId();
            return this.crossRepositoryConstraint(ProjectUtil.generateRepositoryConstraint(project));
        }

        public Builder project(Integer projectId) {
            this.projectId = projectId;
            return this.crossRepositoryConstraint(ProjectUtil.generateRepositoryConstraint(ProjectUtil.getProjectById(projectId)));
        }

        public ActivityItemSearchParams build() {
            if (this.maxItems == -1) {
                throw new IllegalStateException("Must set maxItems before calling build()");
            }
            if (this.tz == null) {
                throw new IllegalStateException("Must set a timezone before calling build()");
            }
            if (!(this.includeCruData || this.includeExternals || this.includeFEData)) {
                throw new IllegalStateException("Configuration of ActivityItemSearchParameters will disable all providers");
            }
            if (this.searchSortOrder == null) {
                this.searchSortOrder = SearchSortOrder.TOWARDS_PAST;
            }
            return new ActivityItemSearchParams(this.isDownStream, this.repFilter, this.tz, this.minDate, this.maxDate, this.searchSortOrder, this.maxItems, this.committers, this.paths, this.userFilter, this.reviewIds, this.projectId, this.minDateString, this.maxDateString, this.changelogExplorer, this.includeCruData, this.includeFEData, this.includeExternals, this.crossRepConstraints, this.includeUserInDownstream, this.changeset, this.forcedAnchorAtLatest, this.wbFilter);
        }

        public Builder timeZone(TimeZone tz) {
            this.tz = tz;
            return this;
        }

        public Builder user(String user) {
            this.userFilter = user;
            return this;
        }

        public Builder anyCommitter(String repname, String committer) {
            this.repFilter = repname;
            this.committers.add(committer);
            return this;
        }

        public Builder crossRepositoryConstraint(RepositoryConstraints constraints) {
            this.crossRepConstraints = constraints;
            return this;
        }

        public Builder path(String repname, Path path) {
            this.repFilter = repname;
            this.paths.add(path);
            return this;
        }

        public Builder repository(String rep) {
            this.repFilter = rep;
            return this;
        }

        public Builder reviewIds(IntSet reviewIds) {
            this.reviewIds.addAll((IntCollection)reviewIds);
            return this;
        }

        public Builder reviewId(int reviewId) {
            this.reviewIds.add(reviewId);
            return this;
        }

        public Builder setCompulsoryCommitter(String committer) {
            this.wbFilter.setAuthor(committer);
            return this;
        }

        public Builder setBranch(String branch) {
            this.wbFilter.setBranch(branch);
            return this;
        }

        public Builder setCommentSearchText(String text) {
            this.wbFilter.setCommentSearchText(text);
            return this;
        }

        public Builder setFilename(String filename) {
            this.wbFilter.setFileName(filename);
            return this;
        }

        public Builder setFileExtension(String fileExtension) {
            this.wbFilter.setFileExtension(fileExtension);
            return this;
        }

        public Builder minDateString(String minDateString) {
            this.minDateString = minDateString;
            return this;
        }

        public Builder maxDateString(String maxDateString) {
            this.maxDateString = maxDateString;
            return this;
        }

        public Builder changelogExplorer(FisheyeChangelogExplorer changelogExplorer) {
            this.changelogExplorer = changelogExplorer;
            return this;
        }

        public Builder changeset(String repName, String csid) {
            this.changeset = new ChangeSetRef(repName, csid);
            return this;
        }

        public Builder includeFisheye() {
            this.includeFEData = true;
            return this;
        }

        public Builder includeCrucible() {
            this.includeCruData = true;
            return this;
        }

        public Builder includeExternals() {
            this.includeExternals = true;
            return this;
        }

        public Builder includeUserInDownStream() {
            this.includeUserInDownstream = true;
            return this;
        }

        public Builder excludeCrucible() {
            this.includeCruData = false;
            return this;
        }

        public Builder excludeExternals() {
            this.includeExternals = false;
            return this;
        }

        public Builder setWbFilter(WaybackSpec wb) {
            this.wbFilter = wb;
            return this;
        }
    }
}

