/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.activity;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.fisheye.activity.ActivityItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ActivityItemList {
    public static final ActivityItemList EMPTY = new ActivityItemList(Collections.emptyList());
    private final List<ActivityItem> items;
    private final List<Exception> exceptions;
    private final Map<ApplicationLink, Exception> applinkExceptions;

    public ActivityItemList(List<? extends ActivityItem> items, List<Exception> exceptions) {
        this.items = new ArrayList<ActivityItem>(items);
        this.exceptions = new ArrayList<Exception>(exceptions);
        this.applinkExceptions = Collections.emptyMap();
    }

    public ActivityItemList(Collection<? extends ActivityItem> items, List<Exception> exceptions, Map<ApplicationLink, Exception> applinkExceptions) {
        this.items = new ArrayList<ActivityItem>(items);
        this.exceptions = exceptions;
        this.applinkExceptions = applinkExceptions;
    }

    public ActivityItemList(List<? extends ActivityItem> items, Map<ApplicationLink, Exception> applinkExceptions) {
        this.items = new ArrayList<ActivityItem>(items);
        this.exceptions = Collections.emptyList();
        this.applinkExceptions = applinkExceptions;
    }

    public ActivityItemList(Collection<? extends ActivityItem> items, Map<ApplicationLink, Exception> applinkExceptions) {
        this.items = new ArrayList<ActivityItem>(items);
        this.exceptions = Collections.emptyList();
        this.applinkExceptions = applinkExceptions;
    }

    public ActivityItemList(Collection<? extends ActivityItem> items) {
        this.items = new ArrayList<ActivityItem>(items);
        this.exceptions = Collections.emptyList();
        this.applinkExceptions = Collections.emptyMap();
    }

    public <E extends ActivityItem> void addItems(List<E> items) {
        this.items.addAll(items);
    }

    public ActivityItemList(Exception exception) {
        this.items = Collections.emptyList();
        this.exceptions = Collections.singletonList(exception);
        this.applinkExceptions = Collections.emptyMap();
    }

    public List<ActivityItem> getItems() {
        return this.items;
    }

    public ActivityItem firstItem() {
        return this.items.isEmpty() ? null : this.items.get(0);
    }

    public ActivityItem lastItem() {
        return this.items.isEmpty() ? null : this.items.get(this.items.size() - 1);
    }

    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    public Map<ApplicationLink, Exception> getApplinkExceptions() {
        return this.applinkExceptions;
    }

    public ActivityItemList reverse() {
        ArrayList<ActivityItem> reversed = new ArrayList<ActivityItem>(this.items);
        Collections.reverse(reversed);
        return new ActivityItemList(reversed, this.exceptions, this.applinkExceptions);
    }
}

