/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.web.tags;

import com.atlassian.soy.renderer.SoyException;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.web.soy.SoyRenderer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoyTemplateTag
extends BodyTagSupport {
    private static final Logger log = LoggerFactory.getLogger(SoyTemplateTag.class);
    private static SoyRenderer soyRenderer;
    private static final String DEFAULT_MODULE_KEY = "com.atlassian.auiplugin:aui-experimental-soy-templates";
    protected String template;
    protected Map<String, Object> params = new HashMap<String, Object>();
    protected String moduleKey;

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getModuleKey() {
        return this.moduleKey;
    }

    public void setModuleKey(String moduleKey) {
        this.moduleKey = moduleKey;
    }

    public void addParameter(String name, Object value) {
        this.addParameterInternal(name, value);
    }

    private void addParameterInternal(String name, Object value) {
        this.params.put(name, value);
    }

    public Map<String, Object> getParameters() {
        return this.params;
    }

    public int doEndTag() throws JspException {
        if (StringUtils.isEmpty((String)this.moduleKey)) {
            this.moduleKey = DEFAULT_MODULE_KEY;
        }
        if (StringUtils.isEmpty((String)this.template)) {
            throw new JspTagException("Failed to render soy tag. You need to pass in a template.");
        }
        if (!StringUtils.isEmpty((String)this.id)) {
            this.addParameterInternal("id", this.id);
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("Using template '%s' from module '%s'", (Object)this.template, (Object)this.moduleKey);
            }
            String output = this.getSoyRenderer().render(this.moduleKey, this.template, this.getParameters());
            JspWriter jspWriter = this.pageContext.getOut();
            jspWriter.write(output);
            int n2 = 6;
            return n2;
        }
        catch (SoyException e2) {
            throw new JspTagException("Soy rendering failed for template '%s'.", (Throwable)e2);
        }
        catch (IOException e3) {
            throw new JspTagException("Failed to render soy tag, using template '%s' from module '%s'.", (Throwable)e3);
        }
        finally {
            this.params = new HashMap<String, Object>();
        }
    }

    private SoyRenderer getSoyRenderer() {
        if (soyRenderer == null) {
            soyRenderer = (SoyRenderer)SpringContext.getComponent("soyRenderer");
        }
        return soyRenderer;
    }
}

