/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.utils;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpUtils {
    public static void addCacheHeaders(HttpServletResponse response, long maxAgeInMilliSeconds) {
        long maxAgeInSecs = maxAgeInMilliSeconds / 1000L;
        response.setDateHeader("Expires", System.currentTimeMillis() + maxAgeInMilliSeconds);
        response.setHeader("Cache-Control", "public, max-age=" + maxAgeInSecs);
    }

    public static void addCacheHeadersOneHour(HttpServletResponse response) {
        HttpUtils.addCacheHeaders(response, 3600000L);
    }

    public static void addCacheHeadersOneDay(HttpServletResponse response) {
        HttpUtils.addCacheHeaders(response, 86400000L);
    }

    public static Cookie findCookie(HttpServletRequest request, Predicate<Cookie> predicate) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        return (Cookie)Iterables.find(Arrays.asList(cookies), predicate, null);
    }

    public static Cookie findCookieByName(HttpServletRequest request, final String name) {
        return HttpUtils.findCookie(request, new Predicate<Cookie>(){

            public boolean apply(Cookie cookie) {
                return name.equals(cookie.getName());
            }
        });
    }

    public static void removeCookie(HttpServletResponse resp, Cookie cookie) {
        cookie.setMaxAge(0);
        cookie.setValue(null);
        resp.addCookie(cookie);
    }
}

