/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.utils;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Locale;

public class FileTypesByExtension {
    public Type getFileType(String extension) {
        if (null == extension) {
            return null;
        }
        for (Type type : Type.values()) {
            if (!type.matches(extension)) continue;
            return type;
        }
        return null;
    }

    public static enum Type {
        IMAGE("png", "jpg", "jpeg", "ico", "bmp", "tiff", "tif", "raw", "xcf", "psd", "gif", "svg"),
        ARCHIVE("tar", "gz", "tgz", "7z", "bz2", "pkzip", "rar", "zip", "jar", "war", "phar", "ear"),
        CODE("jsp", "java", "jspf", "as", "asp", "cfc", "cfm", "cfml", "pod", "sql", "tpl", "rb", "perl", "php", "tag", "tld", "c", "h", "cpp", "hpp", "cs", "py", "rb", "js", "xwork", "html", "htm", "css", "dtd", "xsl", "cxx", "cc", "scala", "scm", "sh", "cl", "cmake", "xml", "go", "gyp", "rb", "gemspec", "podspec", "thor", "irb", "haml", "pl", "php3", "php4", "php5", "php6", "scala", "gradle", "xhtml", "rss", "atom", "plist", "scss", "less", "sass", "hbs", "json", "ts", "coffee", "hx", "vbs", "vb", "protobuf", "thrift", "lua", "fs", "ml", "lisp", "clj", "mk", "cmake", "hs", "erl", "r", "m", "mm"),
        TEXT("txt", "properties", "mf", "text", "md", "ini");

        private ImmutableSet<String> extensions;

        private Type(String ... extensions) {
            this.extensions = FluentIterable.from(Arrays.asList(extensions)).transform((Function)new Function<String, String>(){

                public String apply(String extension) {
                    return extension.toLowerCase(Locale.US);
                }
            }).toSet();
        }

        private boolean matches(String extension) {
            return this.extensions.contains((Object)extension.toLowerCase(Locale.US));
        }
    }
}

