/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.util.spring;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.util.ClassUtils;

public class DummyFactoryBean
implements FactoryBean<Object> {
    private final Class<?> iface;
    private final ClassLoader proxyClassLoader;

    public DummyFactoryBean(Class<?>[] ifaces) {
        this(ifaces, null);
    }

    public DummyFactoryBean(Class<?>[] ifaces, ClassLoader proxyClassLoader) {
        this.iface = ifaces.length > 1 ? ClassUtils.createCompositeInterface((Class[])ifaces, (ClassLoader)this.findClassLoader()) : ifaces[0];
        this.proxyClassLoader = proxyClassLoader;
    }

    public Object getObject() throws Exception {
        return this.createProxy();
    }

    public Class<?> getObjectType() {
        return this.iface;
    }

    public boolean isSingleton() {
        return false;
    }

    private Object createProxy() {
        InvocationHandler invocationHandler = (proxy, method, args) -> null;
        return Proxy.newProxyInstance(this.findClassLoader(), new Class[]{this.iface}, invocationHandler);
    }

    private ClassLoader findClassLoader() {
        if (this.proxyClassLoader != null) {
            return this.proxyClassLoader;
        }
        if (Thread.currentThread().getContextClassLoader() != null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return this.getClass().getClassLoader();
    }
}

