/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.util;

import com.cenqua.fisheye.logging.Logs;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SafeSAXXMLReaderFactory {
    public XMLReader newSafeXMLReader() throws SAXException, ParserConfigurationException {
        SAXParserFactory factory;
        block2: {
            factory = SAXParserFactory.newInstance();
            try {
                factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            catch (Exception e2) {
                Logs.APP_LOG.warn((Object)("Unable to configure XML parser for safe parsing: " + e2.getClass().getName() + ": " + e2.getMessage()));
                String factoryClass = "/" + factory.getClass().getCanonicalName().replace('.', '/') + ".class";
                URL url = SAXParserFactory.class.getResource(factoryClass);
                if (url == null) break block2;
                Logs.APP_LOG.warn((Object)("SAX parser loaded from " + url));
            }
        }
        SAXParser saxParser = factory.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        xmlReader.setEntityResolver(this.newNoOpEntityResolver());
        return xmlReader;
    }

    public EntityResolver newNoOpEntityResolver() {
        return new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
        };
    }
}

