/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.util;

import com.cenqua.fisheye.logging.Logs;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class PreGeneratedPoolSupplier<T>
implements Supplier<T> {
    private final Supplier<T> itemGenerator;
    private final int getTimeoutSecs;
    private final ExecutorService executorService;
    private final BlockingQueue<T> pool;
    private final Runnable refillRunnable = new Runnable(){

        @Override
        public void run() {
            PreGeneratedPoolSupplier.this.refill();
        }
    };

    public PreGeneratedPoolSupplier(@Nonnull Supplier<T> itemGenerator, int poolSize, int getTimeoutSecs, @Nonnull ExecutorService executorService) {
        this.itemGenerator = itemGenerator;
        this.getTimeoutSecs = getTimeoutSecs;
        this.executorService = executorService;
        this.pool = new LinkedBlockingQueue<T>(poolSize);
    }

    @Nonnull
    public T get() {
        try {
            T item = this.pool.poll(this.getTimeoutSecs, TimeUnit.SECONDS);
            this.triggerRefill();
            if (item == null) {
                throw new IllegalStateException("Timed out on blocking queue get");
            }
            return item;
        }
        catch (InterruptedException e2) {
            throw new RuntimeException(e2);
        }
    }

    private void refill() {
        try {
            Object item;
            while (this.pool.remainingCapacity() > 0 && !Thread.currentThread().isInterrupted() && this.pool.offer(item = this.itemGenerator.get())) {
            }
        }
        catch (Exception e2) {
            Logs.APP_LOG.warn((Object)"refill caused an error", (Throwable)e2);
            throw Throwables.propagate((Throwable)e2);
        }
    }

    public void triggerRefill() {
        this.executorService.submit(this.refillRunnable);
    }
}

