/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.util;

import com.cenqua.fisheye.logging.Logs;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class Patterns {
    private static final Map<Integer, Character> EMBEDDED_FLAGS = ImmutableMap.builder().put((Object)2, (Object)Character.valueOf('i')).put((Object)1, (Object)Character.valueOf('d')).put((Object)8, (Object)Character.valueOf('m')).put((Object)32, (Object)Character.valueOf('s')).put((Object)64, (Object)Character.valueOf('u')).put((Object)4, (Object)Character.valueOf('x')).build();
    private static final int EMBEDDED_FLAGS_MASK = Patterns.or(EMBEDDED_FLAGS.keySet());

    public static Pattern combine(@Nonnull Iterable<Pattern> patterns) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        int i2 = 0;
        for (Pattern pattern : patterns) {
            if (i2 > 0) {
                sb.append(")|(");
            }
            sb.append(Patterns.embeddedFlags(pattern.flags()));
            sb.append(pattern.pattern());
            ++i2;
        }
        sb.append(')');
        return Pattern.compile(sb.toString());
    }

    public static Pattern combine(Pattern ... patterns) {
        return Patterns.combine(Arrays.asList(patterns));
    }

    public static String embeddedFlags(int regexFlags) {
        if ((regexFlags & ~EMBEDDED_FLAGS_MASK) != 0) {
            Logs.APP_LOG.warn((Object)String.format("Patterns: cannot convert pattern flags 0x%x into embedded flags", regexFlags & ~EMBEDDED_FLAGS_MASK));
        }
        if ((regexFlags & EMBEDDED_FLAGS_MASK) != 0) {
            StringBuilder sb = new StringBuilder(9);
            sb.append("(?");
            for (Map.Entry<Integer, Character> flagChar : EMBEDDED_FLAGS.entrySet()) {
                if ((regexFlags & flagChar.getKey()) == 0) continue;
                sb.append(flagChar.getValue());
            }
            sb.append(")");
            return sb.toString();
        }
        return "";
    }

    private static int or(@Nonnull Iterable<Integer> flags) {
        int sum = 0;
        for (Integer flag : flags) {
            sum |= flag.intValue();
        }
        return sum;
    }
}

