/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.util;

import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;

public class HttpClientFactory {
    private static final String HTTP_PROXY_HOST_SYSPROP = "http.proxyHost";
    private static final String HTTP_PROXY_PORT_SYSPROP = "http.proxyPort";
    private static final String HTTP_PROXY_USER_SYSPROP = "http.proxyUser";
    private static final String HTTP_PROXY_PASS_SYSPROP = "http.proxyPassword";
    private static final String HTTP_PROXY_NTLMDOMAIN_SYSPROP = "http.proxyNtlmDomain";
    private static final String HTTP_PROXY_NTLMHOST_SYSPROP = "http.proxyNtlmWorkstation";

    public static HttpClient newHttpClient() {
        HttpClient client = new HttpClient();
        String proxyHost = System.getProperty(HTTP_PROXY_HOST_SYSPROP, null);
        if (proxyHost != null) {
            int port = Integer.getInteger(HTTP_PROXY_PORT_SYSPROP, 80);
            client.getHostConfiguration().setProxy(proxyHost, port);
            String method = System.getProperty("http.proxyAuth", "basic");
            String username = System.getProperty(HTTP_PROXY_USER_SYSPROP, null);
            String password = System.getProperty(HTTP_PROXY_PASS_SYSPROP, null);
            if (username != null) {
                UsernamePasswordCredentials credentials;
                if (method.toLowerCase().equals("ntlm")) {
                    String host = System.getProperty(HTTP_PROXY_NTLMHOST_SYSPROP, "");
                    String domain = System.getProperty(HTTP_PROXY_NTLMDOMAIN_SYSPROP, "");
                    credentials = new NTCredentials(username, password, host, domain);
                } else {
                    credentials = new UsernamePasswordCredentials(username, password);
                }
                HttpState state = new HttpState();
                state.setProxyCredentials(new AuthScope(proxyHost, port), (Credentials)credentials);
                client.setState(state);
            }
        }
        return client;
    }
}

