/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.util;

import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.NoOp;

public class ClassUtils {
    static final String CLASS_SUFFIX = ".class";
    static final Pattern JAR_FILE_FROM_URL_PATTERN = Pattern.compile("file:(.*)!/.*");
    private static final CallbackFilter FINALIZE_FILTER = new CallbackFilter(){

        public int accept(Method method) {
            return method.getParameterTypes().length == 0 && method.getReturnType().equals(Void.TYPE) && "finalize".equals(method.getName()) ? 1 : 0;
        }
    };

    public static <T> Set<Class<T>> getImplementations(ClassLoader classLoader, String packageName, String nameSuffix, Class<T> required) {
        HashSet<Class<T>> compatibleClasses = new HashSet<Class<T>>();
        packageName = packageName.replace(".", "/");
        try {
            Enumeration<URL> resourceEnum = classLoader.getResources(packageName);
            while (resourceEnum.hasMoreElements()) {
                URL url = resourceEnum.nextElement();
                Logs.APP_LOG.debug((Object)("processing url = " + url));
                if (url.getProtocol().equals("jar")) {
                    Matcher matcher = JAR_FILE_FROM_URL_PATTERN.matcher(url.getFile());
                    if (!matcher.matches()) continue;
                    String jarFile = matcher.group(1);
                    compatibleClasses.addAll(ClassUtils.getJarImplementations(jarFile, classLoader, packageName, nameSuffix, required));
                    continue;
                }
                if (!url.getProtocol().equals("file")) continue;
                File packagePath = new File(url.getFile());
                compatibleClasses.addAll(ClassUtils.getDirImplementations(packagePath, packageName, nameSuffix, classLoader, required));
            }
        }
        catch (IOException e2) {
            Logs.APP_LOG.debug((Object)("Unable to list resources for " + packageName));
        }
        return compatibleClasses;
    }

    private static <T> Set<Class<T>> getDirImplementations(File packageDir, String packageName, String nameSuffix, ClassLoader classLoader, Class<T> required) {
        File[] dirs;
        HashSet<Class<T>> dirClasses = new HashSet<Class<T>>();
        FilenameFilter classFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(ClassUtils.CLASS_SUFFIX);
            }
        };
        String packagePath = packageDir.getAbsolutePath();
        packagePath = packagePath.substring(0, packagePath.length() - packageName.length());
        File[] classFiles = packageDir.listFiles(classFilter);
        if (classFiles != null) {
            for (File classFile : classFiles) {
                String path = classFile.getAbsolutePath();
                String className = path.substring(packagePath.length(), path.length() - CLASS_SUFFIX.length());
                if ((className = className.replace(File.separatorChar, '.')).contains("$") || !className.endsWith(nameSuffix)) continue;
                ClassUtils.addClassIfCompatible(classLoader, required, dirClasses, className);
            }
        }
        if ((dirs = packageDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        })) != null) {
            for (File dir : dirs) {
                String subPackageName = packageName + "/" + dir.getName();
                dirClasses.addAll(ClassUtils.getDirImplementations(dir, subPackageName, nameSuffix, classLoader, required));
            }
        }
        return dirClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> Set<Class<T>> getJarImplementations(String jarFile, ClassLoader classLoader, String packageName, String nameSuffix, Class<T> required) {
        HashSet<Class<T>> jarClasses = new HashSet<Class<T>>();
        CloseableJarFile jf = null;
        try {
            jf = new CloseableJarFile(jarFile);
            Enumeration<JarEntry> entries = jf.entries();
            while (entries.hasMoreElements()) {
                String className;
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(packageName) || !name.endsWith(CLASS_SUFFIX) || !(className = (name = name.substring(0, name.length() - CLASS_SUFFIX.length())).replace("/", ".")).endsWith(nameSuffix)) continue;
                ClassUtils.addClassIfCompatible(classLoader, required, jarClasses, className);
            }
        }
        catch (IOException e2) {
            try {
                Logs.APP_LOG.debug((Object)("Unable to open jar file " + jarFile));
            }
            catch (Throwable throwable) {
                IOHelper.close(jf);
                throw throwable;
            }
            IOHelper.close(jf);
        }
        IOHelper.close(jf);
        return jarClasses;
    }

    private static <T> void addClassIfCompatible(ClassLoader classLoader, Class<T> required, Set<Class<T>> classSet, String className) {
        try {
            Class<?> candidateClass = classLoader.loadClass(className);
            if (required.isAssignableFrom(candidateClass)) {
                if (candidateClass.isInterface()) {
                    return;
                }
                if ((candidateClass.getModifiers() & 0x400) != 0) {
                    return;
                }
                classSet.add(candidateClass);
            }
        }
        catch (Throwable e2) {
            Logs.APP_LOG.debug((Object)("Unable to load class for upgrade check: " + className));
        }
    }

    public static Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ClassUtils.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> componentClass = ClassUtils.getClass(componentType);
            if (componentClass != null) {
                return Array.newInstance(componentClass, 0).getClass();
            }
            return null;
        }
        return null;
    }

    public static <T> List<Class<?>> getTypeArguments(Class<T> baseClass, Class<? extends T> childClass) {
        HashMap resolvedTypes = new HashMap();
        Type type = childClass;
        while (!ClassUtils.getClass(type).equals(baseClass)) {
            if (type instanceof Class) {
                type = type.getGenericSuperclass();
                continue;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            for (int i2 = 0; i2 < actualTypeArguments.length; ++i2) {
                resolvedTypes.put(typeParameters[i2], actualTypeArguments[i2]);
            }
            if (rawType.equals(baseClass)) continue;
            type = rawType.getGenericSuperclass();
        }
        Type[] actualTypeArguments = type instanceof Class ? type.getTypeParameters() : ((ParameterizedType)type).getActualTypeArguments();
        ArrayList typeArgumentsAsClasses = new ArrayList();
        for (Type baseType : actualTypeArguments) {
            while (resolvedTypes.containsKey(baseType)) {
                baseType = (Type)resolvedTypes.get(baseType);
            }
            typeArgumentsAsClasses.add(ClassUtils.getClass(baseType));
        }
        return typeArgumentsAsClasses;
    }

    public static Factory createEnhancer(Class type, Callback callback) {
        Enhancer e2 = new Enhancer();
        e2.setSuperclass(type);
        e2.setCallbacks(new Callback[]{callback, NoOp.INSTANCE});
        e2.setCallbackFilter(FINALIZE_FILTER);
        return (Factory)e2.create();
    }

    public static class CloseableJarFile
    extends JarFile
    implements Closeable {
        public CloseableJarFile(String name) throws IOException {
            super(name);
        }
    }
}

