/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.usersettings;

import com.atlassian.crucible.spi.TxCallback;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.usersettings.SettingType;
import com.atlassian.fecru.usersettings.UserSetting;
import com.atlassian.fecru.usersettings.UserSettingsManager;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.fugue.Effect;
import com.atlassian.fugue.Option;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;

@Component
@AvailableToPlugins
public class UserSettingsManagerImpl
implements UserSettingsManager {
    private final TxTemplate txTemplate;

    @Autowired
    public UserSettingsManagerImpl(TxTemplate txTemplate) {
        this.txTemplate = txTemplate;
    }

    private Session session() {
        return HibernateUtil.currentSession();
    }

    @Override
    public void putString(final FecruUser user, final String key, final String value) {
        UserSettingsManagerImpl.checkKey(key);
        this.checkUserNotNull(user);
        if (value == null) {
            throw new IllegalArgumentException("Value supplied for key '" + key + "' must not be null");
        }
        this.txTemplate.execute(new TxCallback<Void>(){

            @Override
            public Void doInTransaction(TransactionStatus status) throws Exception {
                UserSetting s2 = UserSettingsManagerImpl.this.findOrCreateSetting(user, key, SettingType.STRING);
                s2.setStringValue(value);
                UserSettingsManagerImpl.this.session().saveOrUpdate((Object)s2);
                return null;
            }
        });
    }

    private UserSetting findOrCreateSetting(FecruUser user, String key, SettingType type) {
        Option<UserSetting> uso = this.findSetting(user, key);
        UserSetting us = (UserSetting)uso.getOrElse((Object)new UserSetting(user, key, type));
        return us;
    }

    private Option<UserSetting> findSetting(FecruUser user, String key) {
        Query q2 = this.session().createQuery("from UserSetting us where us.user = :user and us.key = :key");
        q2.setEntity("user", (Object)user);
        q2.setString("key", key);
        return Option.option((Object)((UserSetting)q2.uniqueResult()));
    }

    @Override
    public void putLong(final FecruUser user, final String key, final long value) {
        UserSettingsManagerImpl.checkKey(key);
        this.checkUserNotNull(user);
        this.txTemplate.execute(new TxCallback<Void>(){

            @Override
            public Void doInTransaction(TransactionStatus status) throws Exception {
                UserSetting s2 = UserSettingsManagerImpl.this.findOrCreateSetting(user, key, SettingType.LONG);
                s2.setLongValue(value);
                UserSettingsManagerImpl.this.session().saveOrUpdate((Object)s2);
                return null;
            }
        });
    }

    @Override
    public void putBoolean(final FecruUser user, final String key, final boolean value) {
        UserSettingsManagerImpl.checkKey(key);
        this.checkUserNotNull(user);
        this.txTemplate.execute(new TxCallback<Void>(){

            @Override
            public Void doInTransaction(TransactionStatus status) throws Exception {
                UserSetting s2 = UserSettingsManagerImpl.this.findOrCreateSetting(user, key, SettingType.BOOL);
                s2.setBooleanValue(value);
                UserSettingsManagerImpl.this.session().saveOrUpdate((Object)s2);
                return null;
            }
        });
    }

    @Override
    public Set<String> getKeys(FecruUser user) {
        this.checkUserNotNull(user);
        Query q2 = this.session().createQuery("select key from UserSetting us where us.user = :user");
        q2.setEntity("user", (Object)user);
        return new HashSet<String>(q2.list());
    }

    @Override
    public Map<String, UserSetting> getSettings(FecruUser user) {
        this.checkUserNotNull(user);
        Query q2 = this.session().createQuery("from UserSetting us where us.user = :user");
        q2.setEntity("user", (Object)user);
        return Maps.uniqueIndex((Iterable)q2.list(), (Function)new Function<UserSetting, String>(){

            public String apply(UserSetting us) {
                return us.getKey();
            }
        });
    }

    @Override
    public void remove(FecruUser user, String key) {
        UserSettingsManagerImpl.checkKey(key);
        this.checkUserNotNull(user);
        this.findSetting(user, key).foreach((Effect)new Effect<UserSetting>(){

            public void apply(final UserSetting userSetting) {
                UserSettingsManagerImpl.this.txTemplate.execute(new TxCallback<Void>(){

                    @Override
                    public Void doInTransaction(TransactionStatus status) throws Exception {
                        UserSettingsManagerImpl.this.session().delete((Object)userSetting);
                        return null;
                    }
                });
            }
        });
    }

    @Override
    public Option<String> getString(FecruUser user, String key) {
        UserSettingsManagerImpl.checkKey(key);
        this.checkUserNotNull(user);
        return this.findSetting(user, key).map((Function)new Function<UserSetting, String>(){

            public String apply(UserSetting input) {
                return input.getStringValue();
            }
        });
    }

    @Override
    public Option<Long> getLong(FecruUser user, String key) {
        UserSettingsManagerImpl.checkKey(key);
        this.checkUserNotNull(user);
        return this.findSetting(user, key).map((Function)new Function<UserSetting, Long>(){

            public Long apply(UserSetting input) {
                return input.getLongValue();
            }
        });
    }

    @Override
    public Option<Boolean> getBoolean(FecruUser user, String key) {
        UserSettingsManagerImpl.checkKey(key);
        this.checkUserNotNull(user);
        return this.findSetting(user, key).map((Function)new Function<UserSetting, Boolean>(){

            public Boolean apply(UserSetting input) {
                return input.getBooleanValue();
            }
        });
    }

    protected static void checkKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key may not be null");
        }
        Preconditions.checkArgument((key.length() <= 200 ? 1 : 0) != 0, (Object)("The key '" + key + "' is too long. It must be no more than " + 200 + " characters long."));
    }

    private void checkUserNotNull(FecruUser user) {
        Preconditions.checkNotNull((Object)user, (Object)"user must not be null");
    }
}

