/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.usersettings;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.usersettings.SettingType;
import com.atlassian.fecru.usersettings.UserSettingsManagerImpl;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;

public class UserSetting
implements Serializable {
    private FecruUser user;
    private String key;
    private int type;
    private String value;

    public UserSetting() {
    }

    public UserSetting(FecruUser user, String key, SettingType type) {
        this.user = user;
        this.checkKeyLength(key);
        this.key = key;
        this.type = type.ordinal();
    }

    public UserSetting(FecruUser user, String key, SettingType type, String value) {
        this.user = user;
        this.checkKeyLength(key);
        this.key = key;
        this.type = type.ordinal();
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    private void setValue(String value) {
        this.value = value;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.checkKeyLength(key);
        this.key = key;
    }

    public FecruUser getUser() {
        return this.user;
    }

    public void setUser(FecruUser user) {
        this.user = user;
    }

    private void setSettingType(SettingType type) {
        this.type = type.ordinal();
    }

    public SettingType getSettingType() {
        return SettingType.values()[this.type];
    }

    public String getStringValue() {
        this.checkType(SettingType.STRING);
        return this.value;
    }

    public long getLongValue() {
        this.checkType(SettingType.LONG);
        return Long.parseLong(this.value);
    }

    public boolean getBooleanValue() {
        this.checkType(SettingType.BOOL);
        return Boolean.parseBoolean(this.value);
    }

    public void setStringValue(String stringValue) {
        this.setSettingType(SettingType.STRING);
        this.value = stringValue;
    }

    public void setLongValue(long longValue) {
        this.setSettingType(SettingType.LONG);
        this.value = Long.toString(longValue);
    }

    public void setBooleanValue(boolean booleanValue) {
        this.setSettingType(SettingType.BOOL);
        this.value = Boolean.toString(booleanValue);
    }

    public Object getObjectValue() {
        switch (this.getSettingType()) {
            case STRING: {
                return this.getStringValue();
            }
            case LONG: {
                return this.getLongValue();
            }
            case BOOL: {
                return this.getBooleanValue();
            }
        }
        throw new IllegalStateException("Unexpected setting type:" + (Object)((Object)this.getSettingType()));
    }

    private void checkType(SettingType type) {
        Preconditions.checkArgument((boolean)this.getSettingType().equals((Object)type), (Object)("Setting for User " + (this.user == null ? "null" : this.user.getUsername()) + " with key " + this.key + " is of type " + this.getSettingType().name() + ", not " + type.name()));
    }

    private void checkKeyLength(String key) {
        UserSettingsManagerImpl.checkKey(key);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        UserSetting that = (UserSetting)o2;
        return Objects.equal((Object)this.user, (Object)that.user) && Objects.equal((Object)this.key, (Object)that.key);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.user, this.key});
    }
}

