/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.user.crowd.dao;

import com.atlassian.crowd.dao.user.UserDAOHibernate;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.user.InternalUser;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.FecruUserDAO;
import com.cenqua.fisheye.user.UserRenamer;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class CrowdUserDao
extends UserDAOHibernate {
    private static final Logger log = Logger.getLogger(CrowdUserDao.class);
    private final FecruUserDAO userDAO;
    private final UserRenamer userRenamer;

    @Autowired
    public CrowdUserDao(FecruUserDAO userDAO, UserRenamer userRenamer) {
        this.userDAO = userDAO;
        this.userRenamer = userRenamer;
    }

    public InternalUser add(com.atlassian.crowd.model.user.User user, PasswordCredential credential) throws DirectoryNotFoundException, UserAlreadyExistsException {
        InternalUser added = super.add(user, credential);
        if (!this.userDAO.existsAny(added.getName())) {
            FecruUser fecruUser = new FecruUser(added.getName());
            this.userDAO.create(fecruUser);
            if (!fecruUser.isCrowdBacked()) {
                fecruUser.setBackingCrowdUser((User)added);
            }
        }
        return added;
    }

    public InternalUser rename(com.atlassian.crowd.model.user.User user, String newUsername) throws UserNotFoundException, UserAlreadyExistsException {
        String oldUsername = user.getName();
        InternalUser renamed = super.rename(user, newUsername);
        if (!IdentifierUtils.equalsInLowerCase((String)newUsername, (String)oldUsername)) {
            if (!this.userDAO.existsAny(newUsername)) {
                this.userRenamer.rename(oldUsername, newUsername);
            } else {
                log.warn((Object)("User with name " + newUsername + " already exists. " + "Not modifying associated FishEye/Crucible user."));
            }
        }
        return renamed;
    }
}

