/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.user.crowd.batch;

import com.atlassian.crowd.util.persistence.hibernate.batch.AbstractBatchProcessor;
import com.atlassian.fecru.tx.SpringThreadLocalTransaction;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;

public class HibernateUtilBatchProcessor
extends AbstractBatchProcessor<Session> {
    private final CurrentSessionProvider currentSessionProvider;
    private final SpringThreadLocalTransaction transaction;

    @Autowired
    public HibernateUtilBatchProcessor(CurrentSessionProvider currentSessionProvider, PlatformTransactionManager platformTransactionManager) {
        this.currentSessionProvider = currentSessionProvider;
        this.transaction = new SpringThreadLocalTransaction(platformTransactionManager);
    }

    protected void beforeProcessCollection() {
    }

    protected void afterProcessCollection() {
        this.flushAndClearSession();
    }

    protected void beforeProcessBatch() {
        this.transaction.begin();
    }

    protected void afterProcessBatch() {
        this.transaction.commit();
        this.flushAndClearSession();
    }

    protected void rollbackProcessBatch() {
        this.transaction.rollback();
    }

    protected void beforeProcessIndividual() {
        this.transaction.begin();
    }

    protected void afterProcessIndividual() {
        this.transaction.commit();
    }

    protected void rollbackProcessIndividual() {
        this.transaction.rollback();
    }

    protected Session getSession() {
        return this.currentSessionProvider.currentSession();
    }

    protected void flushAndClearSession() {
        this.getSession().flush();
        this.getSession().clear();
    }
}

