/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.user.crowd.batch;

import com.atlassian.crowd.dao.CriteriaFactory;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.util.persistence.hibernate.batch.AbstractBatchFinder;
import com.atlassian.fecru.tx.SpringThreadLocalTransaction;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;

public class HibernateUtilBatchFinder
extends AbstractBatchFinder {
    private final CurrentSessionProvider currentSessionProvider;
    private final SpringThreadLocalTransaction transaction;

    @Autowired
    public HibernateUtilBatchFinder(CurrentSessionProvider currentSessionProvider, PlatformTransactionManager platformTransactionManager) {
        this.currentSessionProvider = currentSessionProvider;
        this.transaction = new SpringThreadLocalTransaction(platformTransactionManager);
    }

    protected <E> Collection<E> processBatchFind(long directoryID, Collection<String> names, Class<E> persistentClass) {
        ImmutableList lowercaseNames = ImmutableList.copyOf((Iterable)Iterables.transform(names, (Function)IdentifierUtils.TO_LOWER_CASE));
        return CriteriaFactory.createCriteria((Session)this.session(), persistentClass).add((Criterion)Restrictions.eq((String)"directory.id", (Object)directoryID)).add(Restrictions.in((String)"lowerName", (Collection)lowercaseNames)).list();
    }

    protected void beforeFind() {
        this.transaction.begin();
    }

    protected void afterFind() {
        this.transaction.commit();
        this.session().flush();
        this.session().clear();
    }

    private Session session() {
        return this.currentSessionProvider.currentSession();
    }
}

