/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.user.crowd.batch;

import com.atlassian.crowd.model.user.InternalUser;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchProcessor;
import com.atlassian.crowd.util.persistence.hibernate.batch.HibernateOperation;
import com.atlassian.crowd.util.persistence.hibernate.batch.TransactionGroup;
import com.atlassian.crowd.util.persistence.hibernate.batch.hibernate4.operation.MergeOperation;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.FecruUserDAO;
import com.atlassian.fecru.user.UserProfile;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;

public class CrowdUserBatchProcessor
implements BatchProcessor<Session> {
    private final BatchProcessor<Session> delegate;
    private final FecruUserDAO userDAO;
    private final Function<Serializable, Serializable> STRIP_FECRU_USERS = this.remapUserTransactionGroups(transactionGroup -> new TransactionGroup(transactionGroup.getPrimaryObject(), (Collection)transactionGroup.getDependantObjects().stream().filter(o2 -> o2.getClass() != FecruUser.class).collect(Collectors.toList())));
    private final Function<Serializable, Optional<TransactionGroup<InternalUser, Serializable>>> TO_USER_TRANSACTION_GROUP = o2 -> {
        TransactionGroup tg;
        Serializable primary;
        if (o2 instanceof TransactionGroup && (primary = (tg = (TransactionGroup)o2).getPrimaryObject()) instanceof InternalUser) {
            return Optional.of(tg);
        }
        return Optional.empty();
    };

    @Autowired
    public CrowdUserBatchProcessor(BatchProcessor<Session> delegate, FecruUserDAO userDAO) {
        this.delegate = delegate;
        this.userDAO = userDAO;
    }

    public <E extends Serializable> BatchResult<E> execute(HibernateOperation<Session> operation, Collection<E> objects) {
        if (!(operation instanceof MergeOperation)) {
            return this.delegate.execute(operation, objects);
        }
        Stream<String> usernames = objects.stream().map(this.TO_USER_TRANSACTION_GROUP).filter(Optional::isPresent).map(tg -> ((InternalUser)((TransactionGroup)tg.get()).getPrimaryObject()).getName());
        Set<String> existingFecruUsers = this.userDAO.findExistingUsers(usernames);
        List objectsWithFecruUsers = objects.stream().map(this.addMissingFecruUsers(existingFecruUsers)).collect(Collectors.toList());
        BatchResult delegateResult = this.delegate.execute(operation, objectsWithFecruUsers);
        BatchResult result = new BatchResult(delegateResult.getTotalAttempted());
        result.addSuccesses((Collection)delegateResult.getSuccessfulEntities().stream().map(this.STRIP_FECRU_USERS).collect(Collectors.toList()));
        result.addFailures((Collection)delegateResult.getFailedEntities().stream().map(this.STRIP_FECRU_USERS).collect(Collectors.toList()));
        return result;
    }

    private Function<Serializable, Serializable> addMissingFecruUsers(Set<String> existingUsers) {
        return this.remapUserTransactionGroups(transactionGroup -> {
            InternalUser user = (InternalUser)transactionGroup.getPrimaryObject();
            if (existingUsers.contains(user.getLowerName())) {
                return transactionGroup;
            }
            FecruUser fecruUser = new FecruUser(user.getName());
            fecruUser.setUserProfile(new UserProfile(fecruUser));
            return new TransactionGroup((Serializable)user, (Collection)ImmutableList.builder().addAll((Iterable)transactionGroup.getDependantObjects()).add((Object)fecruUser).build());
        });
    }

    private Function<Serializable, Serializable> remapUserTransactionGroups(Function<TransactionGroup<InternalUser, Serializable>, TransactionGroup<InternalUser, Serializable>> transactionGroupMapper) {
        return o2 -> {
            Optional<TransactionGroup<InternalUser, Serializable>> transactionGroup = this.TO_USER_TRANSACTION_GROUP.apply((Serializable)o2);
            if (!transactionGroup.isPresent()) {
                return o2;
            }
            return (Serializable)transactionGroup.map(transactionGroupMapper).get();
        };
    }
}

