/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.user.crowd;

import com.atlassian.crowd.directory.SynchronisableDirectory;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectorySynchroniser;
import com.atlassian.crowd.manager.directory.SynchronisationMode;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.user.crowd.event.RemoteDirectorySynchronisationStartedEvent;
import org.springframework.beans.factory.annotation.Autowired;

public class NotifyingDirectorySynchroniser
implements DirectorySynchroniser {
    private final DirectorySynchroniser delegate;
    private final EventPublisher eventPublisher;

    @Autowired
    public NotifyingDirectorySynchroniser(DirectorySynchroniser delegate, EventPublisher eventPublisher) {
        this.delegate = delegate;
        this.eventPublisher = eventPublisher;
    }

    public void synchronise(SynchronisableDirectory synchronisableDirectory, SynchronisationMode mode) throws DirectoryNotFoundException, OperationFailedException {
        this.eventPublisher.publish((Object)new RemoteDirectorySynchronisationStartedEvent(synchronisableDirectory.getDirectoryId()));
        this.delegate.synchronise(synchronisableDirectory, mode);
    }

    public boolean isSynchronising(long directoryId) throws DirectoryNotFoundException {
        return this.delegate.isSynchronising(directoryId);
    }
}

