/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.user.crowd;

import com.atlassian.crowd.embedded.api.ApplicationFactory;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.DirectoryCurrentlySynchronisingException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationManagerException;
import com.atlassian.fecru.user.crowd.DelegatingCrowdDirectoryService;

public class FecruCrowdDirectoryService
extends DelegatingCrowdDirectoryService {
    private final ApplicationManager applicationManager;
    private final ApplicationFactory applicationFactory;

    public FecruCrowdDirectoryService(CrowdDirectoryService crowdDirectoryService, ApplicationManager applicationManager, ApplicationFactory applicationFactory) {
        super(crowdDirectoryService);
        this.applicationManager = applicationManager;
        this.applicationFactory = applicationFactory;
    }

    @Override
    public Directory addDirectory(Directory directory) throws OperationFailedException {
        Directory addedDirectory = this.delegate.addDirectory(directory);
        try {
            this.applicationManager.addDirectoryMapping(this.applicationFactory.getApplication(), addedDirectory, true, OperationType.values());
        }
        catch (ApplicationNotFoundException | DirectoryNotFoundException e2) {
            throw new OperationFailedException(e2);
        }
        return addedDirectory;
    }

    @Override
    public boolean removeDirectory(long directoryId) throws DirectoryCurrentlySynchronisingException, OperationFailedException {
        Directory directory = this.delegate.findDirectoryById(directoryId);
        if (directory != null) {
            try {
                this.applicationManager.removeDirectoryFromApplication(directory, this.applicationFactory.getApplication());
            }
            catch (ApplicationManagerException e2) {
                throw new OperationFailedException((Throwable)e2);
            }
            return this.delegate.removeDirectory(directoryId);
        }
        return false;
    }
}

