/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.user.activeobjects;

import com.atlassian.activeobjects.spi.AbstractTenantAwareDataSourceProvider;
import com.atlassian.activeobjects.spi.DatabaseType;
import com.atlassian.activeobjects.spi.TenantAwareDataSourceProvider;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.tenancy.api.Tenant;
import com.cenqua.crucible.hibernate.DBControlFactory;
import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.google.common.collect.ImmutableMap;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="dataSourceProvider")
@AvailableToPlugins(value=TenantAwareDataSourceProvider.class)
public class FecruDataSourceProvider
extends AbstractTenantAwareDataSourceProvider {
    private static final Map<DBType, DatabaseType> MAPPING = ImmutableMap.builder().put((Object)DBType.HSQL, (Object)DatabaseType.HSQL).put((Object)DBType.MYSQL, (Object)DatabaseType.MYSQL).put((Object)DBType.ORACLE, (Object)DatabaseType.ORACLE).put((Object)DBType.POSTGRESQL, (Object)DatabaseType.POSTGRESQL).put((Object)DBType.SQLSERVER2005, (Object)DatabaseType.MS_SQL).put((Object)DBType.SQLSERVER2008, (Object)DatabaseType.MS_SQL).put((Object)DBType.SQLSERVER2012, (Object)DatabaseType.MS_SQL).build();
    private final DBControlFactory dbControlFactory;
    private final DataSource dataSource;

    @Autowired
    public FecruDataSourceProvider(DBControlFactory dbControlFactory) {
        this.dbControlFactory = dbControlFactory;
        this.dataSource = new DBControlDataSource();
    }

    @Nonnull
    public DataSource getDataSource(@Nonnull Tenant tenant) {
        return this.dataSource;
    }

    @Nonnull
    public DatabaseType getDatabaseType(@Nonnull Tenant tenant) {
        DatabaseType type = MAPPING.get((Object)this.dbControlFactory.getCurrentControl().getType());
        if (type == null) {
            throw new RuntimeException("No DatabaseType mapping for " + this.dbControlFactory.getCurrentControl().getType().getDisplayName());
        }
        return type;
    }

    class DBControlDataSource
    implements DataSource {
        DBControlDataSource() {
        }

        @Override
        public Connection getConnection() throws SQLException {
            return HibernateUtil.getActiveObjectsConnection();
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            throw new UnsupportedOperationException();
        }
    }
}

