/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.user;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.notification.DeliverySchedule;
import com.cenqua.fisheye.AppConfig;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.nio.charset.Charset;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class UserProfile
implements Serializable {
    public static final int WATCH_INSTANT = 0;
    public static final int WATCH_NIGHTLY = 1;
    public static final int EMAIL_TEXT = 0;
    public static final int EMAIL_HTML = 1;
    private Integer userId;
    private FecruUser user;
    private String cookiePrefs = "";
    private int tabwidth = AppConfig.DEFAULT_TAB_WIDTH;
    private int watchMode = 0;
    private int emailFormat = 1;
    private int changesetsPerPage = 30;
    private int maxFilesPerChangeset = 5;
    private int ideConnectorPort = 51235;
    private boolean enableIde = true;
    private int context = 3;
    private String uploadType = "patch";
    private String uploadMethod = "file";
    private String uploadCharset = Charset.defaultCharset().name();
    private boolean autoMarkFilesRead = true;
    private boolean dontSendMeMyNotifications = true;
    private int stateChangeEmailNotification = DeliverySchedule.IMMEDIATE;
    private int commentEmailNotification = DeliverySchedule.IMMEDIATE;
    private int replyEmailNotification = DeliverySchedule.IMMEDIATE;
    private int generalEmailNotification = DeliverySchedule.IMMEDIATE;
    private int completeEmailNotification = DeliverySchedule.IMMEDIATE;
    private int autoUncompleteEmailNotification = DeliverySchedule.BATCH;
    private boolean uncompleteOnDefect = true;
    private boolean uncompleteOnRevisionAdded = true;
    private String timezone;
    public static final String DEFAULT = "DEFAULT_USER";

    public UserProfile() {
    }

    public UserProfile(FecruUser user) {
        this.setUser(user);
    }

    public UserProfile(FecruUser user, UserProfile that) {
        this(user);
        this.tabwidth = that.tabwidth;
        this.watchMode = that.watchMode;
        this.emailFormat = that.emailFormat;
        this.cookiePrefs = that.cookiePrefs;
        this.changesetsPerPage = that.changesetsPerPage;
        this.maxFilesPerChangeset = that.maxFilesPerChangeset;
        this.ideConnectorPort = that.ideConnectorPort;
        this.enableIde = that.enableIde;
        this.context = that.context;
        this.uploadType = that.uploadType;
        this.uploadMethod = that.uploadMethod;
        this.uploadCharset = that.uploadCharset;
        this.autoMarkFilesRead = that.autoMarkFilesRead;
        this.dontSendMeMyNotifications = that.dontSendMeMyNotifications;
        this.stateChangeEmailNotification = that.stateChangeEmailNotification;
        this.commentEmailNotification = that.commentEmailNotification;
        this.replyEmailNotification = that.replyEmailNotification;
        this.generalEmailNotification = that.generalEmailNotification;
        this.completeEmailNotification = that.completeEmailNotification;
        this.autoUncompleteEmailNotification = that.autoUncompleteEmailNotification;
        this.uncompleteOnDefect = that.uncompleteOnDefect;
        this.uncompleteOnRevisionAdded = that.uncompleteOnRevisionAdded;
    }

    public FecruUser getUser() {
        return this.user;
    }

    void setUser(FecruUser user) {
        this.user = user;
        if (user != null) {
            this.userId = user.getId();
        }
    }

    private Integer getUserId() {
        return this.userId;
    }

    public String getUsername() {
        return this.user.getUsername();
    }

    public int getTabwidth() {
        return this.tabwidth;
    }

    public void setTabwidth(int tabwidth) {
        this.tabwidth = tabwidth;
    }

    public String getCookiePrefs() {
        return StringUtils.defaultString((String)this.cookiePrefs, (String)"");
    }

    public void setCookiePrefs(String cookiePrefs) {
        this.cookiePrefs = cookiePrefs;
    }

    public int getWatchMode() {
        return this.watchMode;
    }

    public void setWatchMode(int watchMode) {
        this.watchMode = watchMode;
    }

    public int getEmailFormat() {
        return this.emailFormat;
    }

    public void setEmailFormat(int emailFormat) {
        this.emailFormat = emailFormat;
    }

    public boolean isHtmlEmailFormat() {
        return this.emailFormat == 1;
    }

    public boolean isNightlyWatchMode() {
        return this.watchMode == 1;
    }

    public int getChangesetsPerPage() {
        return this.changesetsPerPage;
    }

    public void setChangesetsPerPage(int changesetsPerPage) {
        this.changesetsPerPage = changesetsPerPage;
    }

    public int getMaxFilesPerChangeset() {
        return this.maxFilesPerChangeset;
    }

    public void setMaxFilesPerChangeset(int maxFilesPerChangeset) {
        this.maxFilesPerChangeset = maxFilesPerChangeset;
    }

    public int getIdeConnectorPort() {
        return this.ideConnectorPort;
    }

    public void setIdeConnectorPort(int ideConnectorPort) {
        this.ideConnectorPort = ideConnectorPort;
    }

    public boolean isEnableIde() {
        return this.enableIde;
    }

    public void setEnableIde(boolean enableIde) {
        this.enableIde = enableIde;
    }

    public int getContext() {
        return this.context;
    }

    public void setContext(int context) {
        this.context = context;
    }

    public String getUploadType() {
        return this.uploadType;
    }

    public void setUploadType(String uploadType) {
        this.uploadType = uploadType;
    }

    public String getUploadMethod() {
        return this.uploadMethod;
    }

    public void setUploadMethod(String uploadMethod) {
        this.uploadMethod = uploadMethod;
    }

    public String getUploadCharset() {
        return this.uploadCharset;
    }

    public void setUploadCharset(String uploadCharset) {
        this.uploadCharset = uploadCharset;
    }

    public boolean isAutoMarkFilesRead() {
        return this.autoMarkFilesRead;
    }

    public void setAutoMarkFilesRead(boolean autoMarkFilesRead) {
        this.autoMarkFilesRead = autoMarkFilesRead;
    }

    public int getAutoUncompleteEmailNotification() {
        return this.autoUncompleteEmailNotification;
    }

    public void setAutoUncompleteEmailNotification(int autoUncompleteEmailNotification) {
        this.autoUncompleteEmailNotification = autoUncompleteEmailNotification;
    }

    public boolean getUncompleteOnDefect() {
        return this.uncompleteOnDefect;
    }

    public void setUncompleteOnDefect(boolean uncompleteOnDefect) {
        this.uncompleteOnDefect = uncompleteOnDefect;
    }

    public boolean getUncompleteOnRevisionAdded() {
        return this.uncompleteOnRevisionAdded;
    }

    public void setUncompleteOnRevisionAdded(boolean uncompleteOnRevisionAdded) {
        this.uncompleteOnRevisionAdded = uncompleteOnRevisionAdded;
    }

    public boolean getDontSendMeMyNotifications() {
        return this.dontSendMeMyNotifications;
    }

    public void setDontSendMeMyNotifications(boolean dontSendMeMyNotifications) {
        this.dontSendMeMyNotifications = dontSendMeMyNotifications;
    }

    public int getStateChangeEmailNotification() {
        return this.stateChangeEmailNotification;
    }

    public void setStateChangeEmailNotification(int stateChangeEmailNotification) {
        this.stateChangeEmailNotification = stateChangeEmailNotification;
    }

    public int getCommentEmailNotification() {
        return this.commentEmailNotification;
    }

    public void setCommentEmailNotification(int commentEmailNotification) {
        this.commentEmailNotification = commentEmailNotification;
    }

    public int getReplyEmailNotification() {
        return this.replyEmailNotification;
    }

    public void setReplyEmailNotification(int replyEmailNotification) {
        this.replyEmailNotification = replyEmailNotification;
    }

    public int getGeneralEmailNotification() {
        return this.generalEmailNotification;
    }

    public void setGeneralEmailNotification(int generalEmailNotification) {
        this.generalEmailNotification = generalEmailNotification;
    }

    public int getCompleteEmailNotification() {
        return this.completeEmailNotification;
    }

    public void setCompleteEmailNotification(int completeEmailNotification) {
        this.completeEmailNotification = completeEmailNotification;
    }

    @Nullable
    public String getTimezone() {
        return Strings.emptyToNull((String)this.timezone);
    }

    public void setTimezone(String timezone) {
        this.timezone = Strings.emptyToNull((String)timezone);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("userId", (Object)this.userId).add("user", (Object)this.user).add("cookiePrefs", (Object)this.cookiePrefs).add("tabwidth", this.tabwidth).add("watchMode", this.watchMode).add("emailFormat", this.emailFormat).add("changesetsPerPage", this.changesetsPerPage).add("maxFilesPerChangeset", this.maxFilesPerChangeset).add("ideConnectorPort", this.ideConnectorPort).add("enableIde", this.enableIde).add("context", this.context).add("uploadType", (Object)this.uploadType).add("uploadMethod", (Object)this.uploadMethod).add("uploadCharset", (Object)this.uploadCharset).add("autoMarkFilesRead", this.autoMarkFilesRead).add("dontSendMeMyNotifications", this.dontSendMeMyNotifications).add("stateChangeEmailNotification", this.stateChangeEmailNotification).add("commentEmailNotification", this.commentEmailNotification).add("replyEmailNotification", this.replyEmailNotification).add("generalEmailNotification", this.generalEmailNotification).add("completeEmailNotification", this.completeEmailNotification).add("autoUncompleteEmailNotification", this.autoUncompleteEmailNotification).add("uncompleteOnDefect", this.uncompleteOnDefect).add("uncompleteOnRevisionAdded", this.uncompleteOnRevisionAdded).add("timezone", (Object)this.timezone).toString();
    }
}

