/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.user;

import com.atlassian.crowd.event.DirectoryEvent;
import com.atlassian.crowd.event.application.ApplicationDirectoryAddedEvent;
import com.atlassian.crowd.event.application.ApplicationDirectoryOrderUpdatedEvent;
import com.atlassian.crowd.event.application.ApplicationDirectoryRemovedEvent;
import com.atlassian.crowd.event.application.ApplicationUpdatedEvent;
import com.atlassian.crowd.event.directory.DirectoryCreatedEvent;
import com.atlassian.crowd.event.directory.DirectoryDeletedEvent;
import com.atlassian.crowd.event.directory.DirectoryUpdatedEvent;
import com.atlassian.crowd.event.group.GroupCreatedEvent;
import com.atlassian.crowd.event.group.GroupDeletedEvent;
import com.atlassian.crowd.event.group.GroupMembershipCreatedEvent;
import com.atlassian.crowd.event.group.GroupMembershipDeletedEvent;
import com.atlassian.crowd.event.group.GroupUpdatedEvent;
import com.atlassian.crowd.event.user.UserCreatedEvent;
import com.atlassian.crowd.event.user.UserDeletedEvent;
import com.atlassian.crowd.event.user.UserEditedEvent;
import com.atlassian.crowd.event.user.UserRenamedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.license.LicenseChangedEvent;
import com.atlassian.fecru.user.UserListChangedEvent;
import com.atlassian.fecru.user.crowd.event.RemoteDirectorySynchronisationCompleteEvent;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.user.embeddedcrowd.UserSynchronizationStatusManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserListChangedEventPublisher {
    private static final Logger log = Logs.loggerFor(UserListChangedEventPublisher.class);
    private final EventPublisher eventPublisher;
    private final UserSynchronizationStatusManager userSynchronizationStatusManager;
    private final Map<Long, AtomicBoolean> postponingEventsForDirectory = new ConcurrentHashMap<Long, AtomicBoolean>();

    @Autowired
    public UserListChangedEventPublisher(EventPublisher eventPublisher, UserSynchronizationStatusManager userSynchronizationStatusManager) {
        this.eventPublisher = eventPublisher;
        this.userSynchronizationStatusManager = userSynchronizationStatusManager;
    }

    @PostConstruct
    public void postConstruct() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    public void preDestroy() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onLicenseChangedEvent(LicenseChangedEvent ev) {
        this.publishUserListChanged(ev);
    }

    @EventListener
    public void onGroupMembershipCreatedEvent(GroupMembershipCreatedEvent ev) {
        this.publishUserListChangedOrPostponeUntilSynchronizationEnds((DirectoryEvent)ev);
    }

    @EventListener
    public void onGroupMembershipDeletedEvent(GroupMembershipDeletedEvent ev) {
        this.publishUserListChangedOrPostponeUntilSynchronizationEnds((DirectoryEvent)ev);
    }

    @EventListener
    public void onGroupCreatedEvent(GroupCreatedEvent ev) {
        this.publishUserListChangedOrPostponeUntilSynchronizationEnds((DirectoryEvent)ev);
    }

    @EventListener
    public void onGroupUpdatedEvent(GroupUpdatedEvent ev) {
        this.publishUserListChangedOrPostponeUntilSynchronizationEnds((DirectoryEvent)ev);
    }

    @EventListener
    public void onGroupDeletedEvent(GroupDeletedEvent ev) {
        this.publishUserListChangedOrPostponeUntilSynchronizationEnds((DirectoryEvent)ev);
    }

    @EventListener
    public void onUserCreatedEvent(UserCreatedEvent ev) {
        this.publishUserListChangedOrPostponeUntilSynchronizationEnds((DirectoryEvent)ev);
    }

    @EventListener
    public void onUserEditedEvent(UserEditedEvent ev) {
        this.publishUserListChangedOrPostponeUntilSynchronizationEnds((DirectoryEvent)ev);
    }

    @EventListener
    public void onUserDeletedEvent(UserDeletedEvent ev) {
        this.publishUserListChangedOrPostponeUntilSynchronizationEnds((DirectoryEvent)ev);
    }

    @EventListener
    public void onUserRenamedEvent(UserRenamedEvent event) {
        this.publishUserListChangedOrPostponeUntilSynchronizationEnds((DirectoryEvent)event);
    }

    @EventListener
    public void onDirectoryDeletedEvent(DirectoryDeletedEvent ev) {
        this.publishUserListChangedOrPostponeUntilSynchronizationEnds((DirectoryEvent)ev);
    }

    @EventListener
    public void onDirectoryUpdatedEvent(DirectoryUpdatedEvent ev) {
        this.publishUserListChangedOrPostponeUntilSynchronizationEnds((DirectoryEvent)ev);
    }

    @EventListener
    public void onDirectoryCreatedEvent(DirectoryCreatedEvent ev) {
        this.publishUserListChangedOrPostponeUntilSynchronizationEnds((DirectoryEvent)ev);
    }

    @EventListener
    public void onApplicationDirectoryAddedEvent(ApplicationDirectoryAddedEvent ev) {
        this.publishUserListChangedOrPostponeUntilSynchronizationEnds(ev, ev.getDirectoryId());
    }

    @EventListener
    public void onApplicationDirectoryRemovedEvent(ApplicationDirectoryRemovedEvent ev) {
        this.publishUserListChangedOrPostponeUntilSynchronizationEnds(ev, ev.getDirectoryId());
    }

    @EventListener
    public void onApplicationDirectoryOrderUpdatedEvent(ApplicationDirectoryOrderUpdatedEvent ev) {
        this.publishUserListChangedOrPostponeUntilSynchronizationEnds(ev, ev.getDirectoryId());
    }

    @EventListener
    public void onApplicationUpdatedEvent(ApplicationUpdatedEvent ev) {
        this.publishUserListChanged(ev);
    }

    @EventListener
    public void onRemoteDirectorySynchronisationCompleteEvent(RemoteDirectorySynchronisationCompleteEvent ev) {
        long directoryId = ev.getDirectoryId();
        if (this.getDirectoryPostponingFlag(directoryId).compareAndSet(true, false)) {
            log.debug((Object)("Directory " + directoryId + " synchronization complete. Triggering UserListChangedEvent."));
            this.publishUserListChanged(ev);
        }
    }

    private void publishUserListChangedOrPostponeUntilSynchronizationEnds(DirectoryEvent event) {
        this.publishUserListChangedOrPostponeUntilSynchronizationEnds(event, event.getDirectoryId());
    }

    private void publishUserListChangedOrPostponeUntilSynchronizationEnds(Object ev, long directoryId) {
        if (this.userSynchronizationStatusManager.isSynchronisationInProgress(directoryId)) {
            this.getDirectoryPostponingFlag(directoryId).set(true);
        } else {
            this.publishUserListChanged(ev);
        }
    }

    private void publishUserListChanged(Object ev) {
        this.eventPublisher.publish((Object)new UserListChangedEvent(ev));
    }

    private AtomicBoolean getDirectoryPostponingFlag(long directoryId) {
        return this.postponingEventsForDirectory.computeIfAbsent(directoryId, key -> new AtomicBoolean());
    }
}

