/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.user;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.LoginCookieDAO;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.fisheye.user.LoginCookie;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nullable;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class HibernateLoginCookieDAO
implements LoginCookieDAO {
    private CurrentSessionProvider currentSessionProvider;

    @Autowired
    public void setCurrentSessionProvider(CurrentSessionProvider currentSessionProvider) {
        this.currentSessionProvider = currentSessionProvider;
    }

    private Session session() {
        return this.currentSessionProvider.currentSession();
    }

    @Override
    public LoginCookie findCookie(Long loginId) {
        return (LoginCookie)this.session().get(LoginCookie.class, (Serializable)loginId);
    }

    public List<LoginCookie> findCookies(FecruUser user, @Nullable String rnd, @Nullable Integer type, @Nullable String url, @Nullable Boolean recursiveUrl) {
        Preconditions.checkNotNull((Object)user);
        Criteria criteria = this.session().createCriteria(LoginCookie.class);
        criteria.add((Criterion)Restrictions.eq((String)"user", (Object)user));
        if (rnd != null) {
            criteria.add((Criterion)Restrictions.eq((String)"rnd", (Object)rnd));
        }
        if (type != null) {
            criteria.add((Criterion)Restrictions.eq((String)"type", (Object)type));
        }
        if (url != null) {
            criteria.add((Criterion)Restrictions.eq((String)"url", (Object)url));
        }
        if (recursiveUrl != null) {
            criteria.add((Criterion)Restrictions.eq((String)"recursiveUrl", (Object)recursiveUrl));
        }
        return criteria.list();
    }

    public List<LoginCookie> listCookies() {
        return this.session().createCriteria(LoginCookie.class).list();
    }

    @Override
    public LoginCookie findCookie(FecruUser user, Long loginId) {
        return (LoginCookie)this.session().createCriteria(LoginCookie.class).add((Criterion)Restrictions.eq((String)"loginId", (Object)loginId)).add((Criterion)Restrictions.eq((String)"user", (Object)user)).uniqueResult();
    }

    @Override
    public LoginCookie addCookie(LoginCookie loginCookie) {
        this.session().save((Object)loginCookie);
        return loginCookie;
    }

    @Override
    public void updateCookie(LoginCookie loginCookie) {
        this.session().merge((Object)loginCookie);
    }

    @Override
    public boolean deleteCookie(FecruUser user, Long loginId) {
        return this.session().createQuery("delete from LoginCookie lc where lc.loginId = :loginId and lc.user = :user").setParameter("loginId", (Object)loginId).setParameter("user", (Object)user).executeUpdate() > 0;
    }

    @Override
    public boolean deleteCookies(FecruUser user, int type) {
        return this.session().createQuery("delete from LoginCookie lc where lc.type = :type and lc.user = :user").setParameter("type", (Object)type).setParameter("user", (Object)user).executeUpdate() > 0;
    }

    @Override
    public boolean deleteCookiesForUser(FecruUser user) {
        return this.session().createQuery("delete from LoginCookie lc where lc.user = :user").setParameter("user", (Object)user).executeUpdate() > 0;
    }
}

