/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.FecruUserDAO;
import com.atlassian.fecru.user.UserProfile;
import com.atlassian.fecru.utils.collectors.ImmutableCollectors;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.util.CriteriaBatchedInClauseHelper;
import com.cenqua.crucible.util.HqlBatchedInClauseHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.user.UserManager;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public final class FecruUserDAOImpl
implements FecruUserDAO {
    private CurrentSessionProvider currentSessionProvider;

    @Autowired
    public void setCurrentSessionProvider(CurrentSessionProvider currentSessionProvider) {
        this.currentSessionProvider = currentSessionProvider;
    }

    private Session session() {
        return this.currentSessionProvider.currentSession();
    }

    @Override
    public boolean existsAny(String username) {
        try {
            Query query = this.session().createQuery("select 1 from FecruUser where username = :username");
            query.setString("username", UserManager.USERNAME_NORMALIZATION.apply(username));
            return query.uniqueResult() != null;
        }
        catch (HibernateException e2) {
            Logs.APP_LOG.warn((Object)"An error occurred from hibernate. Failing silently", (Throwable)e2);
            return false;
        }
    }

    @Override
    public UserProfile getUserProfile(FecruUser user) {
        return (UserProfile)this.session().createCriteria(UserProfile.class).add((Criterion)Restrictions.eq((String)"user.id", (Object)user.getId())).uniqueResult();
    }

    @Override
    public void updatePasswordResetSrnd(FecruUser user, String passwordResetSRnd, long passwordResetSRndTimestamp) {
        user.setPasswordResetSRnd(passwordResetSRnd);
        user.setPasswordResetTimeStamp(passwordResetSRndTimestamp);
        this.session().saveOrUpdate((Object)user);
    }

    @Override
    public void resetPasswordResetSrnd(FecruUser user) {
        this.updatePasswordResetSrnd(user, null, 0L);
    }

    @Override
    public void updateFailedLoginAttempts(FecruUser user, long newCount) {
        user.setFailedLoginAttempts(newCount);
    }

    @Override
    public Set<String> findExistingUsers(Stream<String> usernames) {
        CriteriaBatchedInClauseHelper existingUsersBatch = new CriteriaBatchedInClauseHelper(this.session(), FecruUser.class, criteria -> criteria.setProjection((Projection)Projections.property((String)"username")), "username", usernames.map(UserManager.USERNAME_NORMALIZATION).collect(Collectors.toList()));
        HashSet existingUsers = Sets.newHashSet();
        existingUsersBatch.execute(username -> {
            existingUsers.add(username);
            return true;
        });
        return existingUsers;
    }

    @Override
    public void create(FecruUser user) {
        this.session().save((Object)user);
        if (user.getUserProfile() == null) {
            user.setUserProfile(new UserProfile(user));
        }
        this.session().save((Object)user.getUserProfile());
    }

    @Override
    public void create(UserProfile profile) {
        this.session().save((Object)profile);
        FecruUser user = profile.getUser();
        if (user != null) {
            this.session().evict((Object)user);
        }
    }

    @Override
    public FecruUser rename(FecruUser user, String username) {
        FecruUser renamedUser = user.rename(username);
        renamedUser = this.merge(renamedUser);
        this.session().flush();
        return renamedUser;
    }

    @Override
    public FecruUser merge(FecruUser user) {
        return (FecruUser)this.session().merge((Object)user);
    }

    @Override
    public void update(UserProfile profile) {
        this.session().update((Object)profile);
    }

    @Override
    public FecruUser getById(int userKey) {
        Query query = this.session().createQuery("from FecruUser where id = :id").setCacheable(true);
        query.setInteger("id", userKey);
        return (FecruUser)query.uniqueResult();
    }

    @Override
    public Iterable<FecruUser> loadUsers(Iterable<User> users) {
        ImmutableMap usersByName = Maps.uniqueIndex(users, user -> UserManager.USERNAME_NORMALIZATION.apply(user.getName()));
        if (usersByName.isEmpty()) {
            return Collections.emptySet();
        }
        HashMap resultsByName = Maps.newHashMapWithExpectedSize((int)usersByName.size());
        Query query = this.session().createQuery("select id, username, passwordResetSRnd, passwordResetTimeStamp, failedLoginAttempts from FecruUser where username in :usernames");
        new HqlBatchedInClauseHelper(query, "usernames", usersByName.keySet()).execute(arg_0 -> this.lambda$loadUsers$91((Map)usersByName, resultsByName, arg_0), false);
        return (Iterable)StreamSupport.stream(users.spliterator(), false).map(user -> (FecruUser)resultsByName.get(UserManager.USERNAME_NORMALIZATION.apply(user.getName()))).filter(user -> user != null).collect(ImmutableCollectors.toList());
    }

    @Override
    public FecruUser getByUsername(String username) {
        if (Strings.emptyToNull((String)username) == null) {
            return null;
        }
        return (FecruUser)this.session().createCriteria(FecruUser.class).add((Criterion)Restrictions.eq((String)"username", (Object)UserManager.USERNAME_NORMALIZATION.apply(username))).setCacheable(true).uniqueResult();
    }

    @Override
    public void delete(String username) {
        FecruUser user = this.getByUsername(username);
        if (user == null) {
            throw new IllegalStateException("Can not delete a non-existent user: " + username);
        }
        if (user.getUserProfile() != null) {
            this.session().delete((Object)user.getUserProfile());
        }
        this.session().delete((Object)user);
    }

    private /* synthetic */ boolean lambda$loadUsers$91(Map usersByName, Map resultsByName, Object[] result) {
        Integer id = (Integer)result[0];
        String username = (String)result[1];
        String passwordResetSRnd = (String)result[2];
        Long passwordResetTimeStamp = (Long)result[3];
        Long failedLoginAttempts = (Long)result[4];
        User backingCrowdUser = (User)usersByName.get(username);
        resultsByName.put(username, new PartialFecruUser(id, username, backingCrowdUser, passwordResetSRnd, passwordResetTimeStamp == null ? 0L : passwordResetTimeStamp, failedLoginAttempts == null ? 0L : failedLoginAttempts));
        return true;
    }

    private class PartialFecruUser
    extends FecruUser {
        private PartialFecruUser(Integer id, String username, User backingCrowdUser, String passwordResetSRnd, long passwordResetTimeStamp, long failedLoginAttempts) {
            super(id, username, null, backingCrowdUser, passwordResetSRnd, passwordResetTimeStamp, failedLoginAttempts);
        }

        @Override
        public synchronized UserProfile getUserProfile() {
            if (this.userProfile == null) {
                this.userProfile = FecruUserDAOImpl.this.getUserProfile(this);
            }
            return this.userProfile;
        }
    }
}

