/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.fecru.user.UserProfile;
import com.cenqua.fisheye.user.UserManager;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FecruUser
implements Serializable,
Cloneable,
Comparable<FecruUser> {
    private Integer id;
    private final String username;
    protected UserProfile userProfile;
    private volatile transient User backingCrowdUser;
    private String passwordResetSRnd;
    private long passwordResetTimeStamp;
    private long failedLoginAttempts;
    private static final Comparator<FecruUser> USERNAME_COMPARATOR = (user1, user2) -> UserManager.USERNAME_NORMALIZATION.apply(user1.getUsername()).compareTo(UserManager.USERNAME_NORMALIZATION.apply(user2.getUsername()));
    public static final Comparator<FecruUser> DISPLAYNAME_COMPARATOR = (user1, user2) -> user1.getDisplayName().compareToIgnoreCase(user2.getDisplayName());

    protected FecruUser() {
        this.username = null;
        this.id = null;
    }

    public FecruUser(String username) {
        this(null, username);
    }

    public FecruUser(Integer id, String username) {
        this(id, username, null);
    }

    FecruUser(Integer id, String username, User backingCrowdUser) {
        this(id, username, null, backingCrowdUser, null, 0L, 0L);
    }

    FecruUser(Integer id, String username, UserProfile userProfile, User backingCrowdUser, String passwordResetSRnd, long passwordResetTimeStamp, long failedLoginAttempts) {
        this.id = id;
        this.username = UserManager.USERNAME_NORMALIZATION.apply(username);
        this.backingCrowdUser = backingCrowdUser;
        this.userProfile = userProfile;
        this.passwordResetTimeStamp = passwordResetTimeStamp;
        this.passwordResetSRnd = passwordResetSRnd;
        this.failedLoginAttempts = failedLoginAttempts;
    }

    public String getUsername() {
        return this.backingCrowdUser != null ? this.backingCrowdUser.getName() : this.username;
    }

    public FecruUser rename(String username) {
        return new FecruUser(this.id, UserManager.USERNAME_NORMALIZATION.apply(username), this.getUserProfile(), this.backingCrowdUser, this.passwordResetSRnd, this.passwordResetTimeStamp, this.failedLoginAttempts);
    }

    public Integer getId() {
        return this.id;
    }

    private void setId(Integer id) {
        this.id = id;
    }

    public Integer getKey() {
        return this.id;
    }

    public String getDisplayName() {
        String displayName;
        String string = displayName = this.backingCrowdUser != null ? this.backingCrowdUser.getDisplayName() : this.getUsername();
        if (Strings.isNullOrEmpty((String)displayName)) {
            return this.getUsername();
        }
        return displayName;
    }

    @Nullable
    public String getEmail() {
        return this.backingCrowdUser != null ? this.backingCrowdUser.getEmailAddress() : null;
    }

    public boolean isEnabled() {
        return this.backingCrowdUser != null && this.backingCrowdUser.isActive();
    }

    public UserProfile getUserProfile() {
        return this.userProfile;
    }

    public void setUserProfile(UserProfile userProfile) {
        if (userProfile != null) {
            userProfile.setUser(this);
        }
        this.userProfile = userProfile;
    }

    public String toString() {
        return this.id + ": " + this.username;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof FecruUser)) {
            return false;
        }
        FecruUser other = (FecruUser)obj;
        return UserManager.USERNAME_NORMALIZATION.apply(this.getUsername()).equals(UserManager.USERNAME_NORMALIZATION.apply(other.getUsername()));
    }

    public int hashCode() {
        return Objects.hash(UserManager.USERNAME_NORMALIZATION.apply(this.getUsername()));
    }

    @Override
    public int compareTo(@Nonnull FecruUser other) {
        return USERNAME_COMPARATOR.compare(this, other);
    }

    public boolean isCrowdBacked() {
        return this.backingCrowdUser != null;
    }

    public void setBackingCrowdUser(User crowdUser) {
        this.backingCrowdUser = crowdUser;
    }

    void setPasswordResetSRnd(String passwordResetSRnd) {
        this.passwordResetSRnd = passwordResetSRnd;
    }

    void setPasswordResetTimeStamp(long passwordResetTimeStamp) {
        this.passwordResetTimeStamp = passwordResetTimeStamp;
    }

    void setFailedLoginAttempts(long failedLoginAttempts) {
        this.failedLoginAttempts = failedLoginAttempts;
    }

    public String getPasswordResetSRnd() {
        return this.passwordResetSRnd;
    }

    public long getPasswordResetTimeStamp() {
        return this.passwordResetTimeStamp;
    }

    public long getFailedLoginAttempts() {
        return this.failedLoginAttempts;
    }
}

