/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.user;

import com.atlassian.crucible.filters.CrucibleFilter;
import com.atlassian.crucible.spi.services.NotPermittedException;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.web.admin.interceptors.LoginInterceptor;
import java.util.LinkedList;
import java.util.TimeZone;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="effectiveUserProvider")
@AvailableToPlugins(value=EffectiveUserProvider.class)
public class EffectiveUserProviderImpl
implements EffectiveUserProvider {
    @Autowired
    private RootConfig rootConfig;
    private final ThreadLocal<LinkedList<EffectiveUser>> user = new ThreadLocal();

    @Override
    public void pushEffectivePrincipal(Principal principal, FecruUser user) {
        this.getStack().addFirst(new EffectiveUser(principal, user));
    }

    @Override
    public void popEffectivePrincipal() {
        LinkedList<EffectiveUser> stack = this.getStack();
        if (stack.isEmpty()) {
            throw new IllegalStateException("The effective user stack is already empty");
        }
        stack.removeFirst();
    }

    @Override
    public TimeZone getEffectiveTimezone() {
        String timezone;
        FecruUser user = this.getEffectiveUser();
        if (user != null && (timezone = user.getUserProfile().getTimezone()) != null) {
            return TimeZone.getTimeZone(timezone);
        }
        return this.rootConfig.getTimezone();
    }

    @Override
    public void ensureAdminPermission() {
        if (!this.isAdmin()) {
            throw new NotPermittedException("You are not authorized to perform this operation");
        }
    }

    private LinkedList<EffectiveUser> getStack() {
        LinkedList<EffectiveUser> stack = this.user.get();
        if (stack == null) {
            stack = new LinkedList();
            this.user.set(stack);
        }
        return stack;
    }

    @Deprecated
    public void setEffectivePrincipal(Principal userLogin, FecruUser cuser) {
        LinkedList<EffectiveUser> stack = this.getStack();
        if (!stack.isEmpty()) {
            stack.removeFirst();
        }
        stack.addFirst(new EffectiveUser(userLogin, cuser));
    }

    @Override
    public Principal getEffectivePrincipal() {
        LinkedList<EffectiveUser> stack = this.getStack();
        if (!stack.isEmpty()) {
            return stack.getFirst().principal;
        }
        return Principal.Anonymous.ANON;
    }

    @Override
    public UserLogin getEffectiveUserLogin() {
        Principal effectivePrincipal = this.getEffectivePrincipal();
        return effectivePrincipal instanceof UserLogin ? (UserLogin)effectivePrincipal : null;
    }

    @Override
    public FecruUser getEffectiveUser() {
        LinkedList<EffectiveUser> stack = this.getStack();
        if (!stack.isEmpty()) {
            return stack.getFirst().user;
        }
        return null;
    }

    @Override
    public boolean isAdmin() {
        UserLogin user = this.getEffectiveUserLogin();
        try {
            boolean isAdminPasswordUser = CrucibleFilter.hasContext() && LoginInterceptor.isAdminUser(CrucibleFilter.getRequest());
            boolean isSuperUser = isAdminPasswordUser || Principal.SuperUser.isSuperUser((Principal)this.getEffectivePrincipal());
            boolean isAdminUser = isSuperUser || user != null && AppConfig.getsConfig().getUserManager().hasSysAdminPrivileges(user.getUsername());
            return isAdminUser;
        }
        catch (DbException e2) {
            Logs.APP_LOG.error((Object)"Error checking for admin privileges", (Throwable)e2);
            return false;
        }
    }

    @Override
    public boolean isAnonymous() {
        return Principal.Anonymous.isAnon((Principal)this.getEffectivePrincipal());
    }

    private static class EffectiveUser {
        final Principal principal;
        final FecruUser user;

        private EffectiveUser(Principal principal, FecruUser user) {
            if (principal != null) {
                this.principal = principal;
                this.user = user;
            } else {
                this.principal = Principal.Anonymous.ANON;
                this.user = null;
            }
        }
    }
}

