/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.user;

import com.atlassian.crucible.spi.TxCallback;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.FecruUserDAO;
import com.atlassian.fecru.user.UserProfile;
import com.atlassian.fecru.user.UserProfileManager;
import com.atlassian.fisheye.spi.TxTemplate;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.UserManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;

@Service(value="userProfileManager")
public class DefaultUserProfileManager
implements UserProfileManager {
    private final FecruUserDAO userDAO;
    private final TxTemplate txTemplate;
    private final UserManager userManager;

    @Autowired
    public DefaultUserProfileManager(FecruUserDAO userDAO, TxTemplate txTemplate, UserManager userManager) {
        this.userDAO = userDAO;
        this.txTemplate = txTemplate;
        this.userManager = userManager;
    }

    @Override
    public UserProfile getProfile(String username) throws DbException {
        FecruUser user = this.getUser(username);
        UserProfile profile = user.getUserProfile();
        if (profile == null) {
            return new UserProfile(user, DEFAULT_PROFILE);
        }
        return profile;
    }

    @Override
    public void setProfile(final String username, final UserProfile profile) throws DbException {
        this.txTemplate.execute(new TxCallback<Object>(){

            @Override
            public Object doInTransaction(TransactionStatus status) throws Exception {
                FecruUser user = DefaultUserProfileManager.this.getUser(username);
                profile.setUser(user);
                if (user.getUserProfile() == null) {
                    DefaultUserProfileManager.this.userDAO.create(profile);
                } else {
                    DefaultUserProfileManager.this.userDAO.update(profile);
                }
                return null;
            }
        });
    }

    @Override
    public UserProfile getDefaultProfile() {
        return new UserProfile(null, DEFAULT_PROFILE);
    }

    private FecruUser getUser(String username) {
        FecruUser user = this.userManager.getLicensedUser(username);
        if (user == null) {
            throw new IllegalStateException("Unknown user: " + username);
        }
        return user;
    }
}

