/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.user;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.util.spring.AbstractSmartLifecycle;
import com.atlassian.fisheye.util.DevMode;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.license.LicenseInfo;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.AdminUserConfig;
import com.cenqua.fisheye.user.GroupMembershipManager;
import com.cenqua.fisheye.user.UserManager;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
final class CreateDefaultUsersTask
extends AbstractSmartLifecycle {
    private final UserManager userManager;
    private final GroupMembershipManager groupMembershipManager;
    private final AdminUserConfig adminUserConfig;

    @Autowired
    CreateDefaultUsersTask(UserManager userManager, GroupMembershipManager groupMembershipManager, AdminUserConfig adminUserConfig) {
        this.userManager = userManager;
        this.groupMembershipManager = groupMembershipManager;
        this.adminUserConfig = adminUserConfig;
    }

    @Override
    public void start() {
        try {
            this.createUsers();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        super.start();
    }

    private void createUsers() throws Exception {
        try {
            if (!DevMode.isDevMode() || !this.noUsersInDb()) {
                return;
            }
            if (this.noLicense()) {
                Logs.APP_LOG.info((Object)"[dev] Can not create default users as no license is present...");
                return;
            }
            Logs.APP_LOG.info((Object)"[dev] Creating default users ...");
            this.addActivatedUser("admin", "System Administrator", "admin@atlassian.com");
            this.addActivatedUser("pmcneil", "Peter McNeil", "pmcneil@cenqua.com");
            this.addActivatedUser("matt", "Matt Quail", "matt@cenqua.com");
            this.addActivatedUser("brendan", "Brendan Humphreys", "brendan@cenqua.com");
            this.addActivatedUser("conor", "Conor MacNeill", "conor@cenqua.com");
            this.addActivatedUser("pete", "Peter Moore", "pete@cenqua.com");
            this.addActivatedUser("nick", "Nick Pellow", "nick@cenqua.com");
            this.addActivatedUser("wseliga", "Wojciech Seliga", "wseliga@atlassian.com");
            this.addActivatedUser("joe", "joe lowercase", "joe.lowercase@atlassian.com");
            this.addActivatedUser("richard", "Richard Stephens", "rstephens@atlassian.com");
            this.addActivatedUser("geoff", "Geoff Crain", "gcrain@atlassian.com");
            this.addActivatedUser("george", "George Filippoff", "gfilippoff@atlassian.com");
            this.addActivatedUser("tom", "Tom Davies", "tdavies@atlassian.com");
            this.addActivatedUser("val", "Val Trubnikov", "vtrubnikov@atlassian.com");
            this.addActivatedUser("xss", "a <font color=\"red\">red</font> person", "xss@atlassian.com");
            this.addActivatedUser("xss2", "\"<!--<img src=\"--><img src=x onerror=AJS.$('body').addClass('xss-detected')//\">", "xss2@atlassian.com");
            this.addActivatedUser("mstudman", "Michael Studman", "mstudman@atlassian.com");
            this.addActivatedUser("lzheng", "Liangliang Zheng", "lzheng@atlassian.com");
            this.addActivatedUser("abraham", "Abraham Son of Terah", "abraham@atlassian.om");
            this.addActivatedUser("judas", "Judas Iscariot", "judas@atlassian.om");
            this.addtoGroup("team-1", "pmcneil");
            this.addtoGroup("team-1", "matt");
            this.addtoGroup("team-1", "brendan");
            this.addtoGroup("team-2", "pmcneil");
            this.addtoGroup("team-2", "conor");
            this.addtoGroup("team-2", "pete");
            this.addtoGroup("team-3", "conor");
            this.addtoGroup("team-3", "matt");
            this.addtoGroup("team-3", "richard");
            this.addtoGroup("team-4", "geoff");
            this.addtoGroup("team-4", "tom");
            this.addtoGroup("team-4", "val");
            this.addtoGroup("team-blue", "abraham");
            this.addtoGroup("team-blue", "judas");
            this.addUserToAdmins("admin");
            this.addUserToAdmins("lzheng");
            Logs.APP_LOG.info((Object)"[dev] Done");
        }
        finally {
            HibernateUtil.closeSession();
        }
    }

    private boolean noLicense() {
        LicenseInfo license = AppConfig.getsConfig().getLicense();
        return license == null || license.getFisheyeLicense() == null;
    }

    private boolean noUsersInDb() {
        return this.userManager.getAllEnabledUsernames().isEmpty();
    }

    private void addActivatedUser(String username, String displayName, String email) throws Exception {
        FecruUser existingUser = this.userManager.getUser(username);
        if (existingUser != null) {
            return;
        }
        this.userManager.addUser(username, displayName, email, username, true);
    }

    private void addtoGroup(String group, String username) throws DbException {
        this.addGroupIfNonExistent(group);
        this.groupMembershipManager.addUserToGroup(group, username);
    }

    private void addGroupIfNonExistent(String group) {
        if (!this.userManager.groupExists(group)) {
            this.userManager.addGroup(group);
        }
    }

    private void addUserToAdmins(String username) throws IOException {
        this.adminUserConfig.addUser(username);
        this.adminUserConfig.save();
    }

    public int getPhase() {
        return 999;
    }
}

