/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.user;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Arrays;

public enum AuthType {
    CUSTOM(4, "custom"),
    AJP(5, "ajp"),
    EMBEDDED_CROWD(10, "embedded-crowd");

    private final int key;
    private final String displayName;

    private AuthType(int key, String displayName) {
        this.key = key;
        this.displayName = displayName;
    }

    public int getKey() {
        return this.key;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public static AuthType fromKey(int key) {
        for (AuthType type : AuthType.values()) {
            if (type.getKey() != key) continue;
            return type;
        }
        throw new IllegalArgumentException(key + "is an invalid key for AuthType");
    }

    public static AuthType fromDisplayNameIgnoreCase(String displayName) {
        for (AuthType authType : AuthType.values()) {
            if (!authType.getDisplayName().equalsIgnoreCase(displayName)) continue;
            return authType;
        }
        throw new IllegalArgumentException(String.format("Type: %s not supported. Should be one of: %s", displayName, AuthType.typesCsv()));
    }

    private static String typesCsv() {
        Iterable displayNames = Iterables.transform(Arrays.asList(AuthType.values()), (Function)new Function<AuthType, String>(){

            public String apply(AuthType authType) {
                return authType.getDisplayName();
            }
        });
        return Iterables.toString((Iterable)displayNames);
    }
}

