/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.upgrade;

import com.atlassian.fecru.gwt.admin.shared.repositories.PolledUpdateOptions;
import com.atlassian.fecru.upgrade.PreUpgradeTask;
import com.atlassian.fecru.upgrade.SystemUpgradeTask;
import com.cenqua.crucible.util.HelpUtil;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.GitRepType;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Ordering;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;

public class ManagedRepoConversionUpgradeTask
implements PreUpgradeTask,
SystemUpgradeTask {
    private static final String MNGD_REPO_END_OF_SUPPORT_ANN_LINK = HelpUtil.getFishEyeHelpPath("fisheye.managed.repositories.eos");
    public static final String MNGD_REPO_MIGRATION_GUIDE_LINK = HelpUtil.getFishEyeHelpPath("fisheye.managed.repositories.migration");

    @Override
    public boolean preUpgradeCheck(RootConfig rootConfig) {
        Collection<RepositoryType> managedRepos = this.getManagedRepos(rootConfig);
        if (managedRepos.isEmpty()) {
            return true;
        }
        this.warnHeader(rootConfig);
        boolean forced = Boolean.getBoolean("fisheye.managed.repos.convert");
        if (forced) {
            this.warnUpgradeForced();
        } else {
            this.warnUpgradeCancelled(rootConfig, managedRepos);
        }
        UWL.warn3Banners();
        return forced;
    }

    Collection<RepositoryType> getManagedRepos(RootConfig rootConfig) {
        RepositoryType[] allRepos = ((RootConfig)Preconditions.checkNotNull((Object)rootConfig, (Object)"rootConfig")).getConfig().getRepositoryArray();
        return Ordering.natural().onResultOf((Function)new Function<RepositoryType, String>(){

            public String apply(RepositoryType repo) {
                return repo.getName();
            }
        }).immutableSortedCopy((Iterable)Collections2.filter(Arrays.asList(allRepos), (Predicate)new Predicate<RepositoryType>(){

            public boolean apply(RepositoryType repo) {
                return repo.isSetManaged() && repo.getManaged();
            }
        }));
    }

    @Override
    public void upgradeConfig(RootConfig rootConfig) {
        Collection<RepositoryType> managedRepos = this.getManagedRepos(rootConfig);
        if (rootConfig.getConfig().isSetRepositoryManagement()) {
            rootConfig.getConfig().unsetRepositoryManagement();
        }
        if (managedRepos.isEmpty()) {
            return;
        }
        UWL.warn("  The following git internally managed repositories were converted to standard repositories:");
        for (RepositoryType managedRepo : managedRepos) {
            this.convertManagedRepoToStandard(managedRepo);
            this.warnRepoListItem(managedRepo);
        }
        UWL.warn3Banners();
        try {
            rootConfig.saveConfig();
        }
        catch (IOException e2) {
            String msg = "Managed Repositories Conversion failed, unable to save new config file due to IO issue";
            Logs.APP_LOG.fatal((Object)"Managed Repositories Conversion failed, unable to save new config file due to IO issue", (Throwable)e2);
            throw new RuntimeException("Managed Repositories Conversion failed, unable to save new config file due to IO issue", e2);
        }
    }

    void convertManagedRepoToStandard(RepositoryType managedRepo) {
        managedRepo.unsetManaged();
        if (managedRepo.isSetGit()) {
            GitRepType git = managedRepo.getGit();
            if (git.isSetUpdater() && new PolledUpdateOptions(git.getUpdater().getPollPeriod()).isNeverPoll()) {
                git.unsetUpdater();
            }
        } else {
            UWL.warn("Found a managed repository of type different to git, skipping poll period reset: " + managedRepo.getName());
        }
    }

    @Override
    public String getName() {
        return "ManagedRepoEOL";
    }

    private void warnHeader(RootConfig rootConfig) {
        UWL.warn3Banners();
        UWL.warn("Internally managed repositories are no longer supported by " + rootConfig.getProductName() + ". ");
        UWL.warn("These were deprecated in FishEye 2.8:");
        UWL.warn(MNGD_REPO_END_OF_SUPPORT_ANN_LINK);
        UWL.warn("");
    }

    private void warnUpgradeCancelled(RootConfig rootConfig, Collection<RepositoryType> managedRepos) {
        UWL.warn("  You can either:");
        UWL.warn("    1. Start the old version of " + rootConfig.getProductName() + " and remove all internally managed repositories,");
        UWL.warn("       then continue with the upgrade");
        UWL.warn("         or");
        UWL.warn("    2. Start " + rootConfig.getProductName() + " with the system property " + "fisheye.managed.repos.convert" + " set to true,");
        UWL.warn("       so all the internally managed repositories will be converted to standard repositories and");
        UWL.warn("       any git interaction with them through the " + rootConfig.getProductName() + " will be disabled.");
        UWL.warn("       You can set this by adding a java system property to the FISHEYE_OPTS environment variable:");
        UWL.warn("         -Dfisheye.managed.repos.convert=true");
        UWL.warn("");
        this.warnMoreInfoOnUpgrade();
        UWL.warn("You have the following git internally managed " + (managedRepos.size() > 1 ? "repositories" : "repository") + " in your configuration:");
        for (RepositoryType repo : managedRepos) {
            this.warnRepoListItem(repo);
        }
    }

    private void warnUpgradeForced() {
        UWL.warn("  You have forced startup having git internally managed repositories defined.");
        UWL.warn("  All of them will be converted to standard repositories, but");
        UWL.warn("  any git interaction with them through FishEye will be disabled.");
        UWL.warn("");
        this.warnMoreInfoOnUpgrade();
    }

    private void warnMoreInfoOnUpgrade() {
        UWL.warn("  Please refer to " + MNGD_REPO_MIGRATION_GUIDE_LINK + " for more information.");
        UWL.warn("");
    }

    private void warnRepoListItem(RepositoryType repo) {
        UWL.warn("      * " + repo.getName() + (repo.getEnabled() ? "" : " (disabled)"));
    }
}

