/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.upgrade;

import com.atlassian.fecru.upgrade.BackgroundUpgradeTask;
import com.atlassian.fisheye.jira.JiraServer;
import com.atlassian.fisheye.jira.JiraServerService;
import com.atlassian.fisheye.jira.RemoteJiraServerVersion;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.PluginState;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.logging.Logs;

public class JiraIntegrationPluginUpgradeTask
implements BackgroundUpgradeTask {
    private static int JIRA_50_BUILDNUMBER = 713;
    private static final String PLUGIN_HAS_COMPLETED_VERSION_CHECK_KEY = "com.atlassian.integration.jira.jira-integration-plugin.HasCompletedJIRAVersionCheck2";
    private static final String JIRA_INTEGRATION = "JIRA integration";

    @Override
    public String getName() {
        return "02-JIRAPluginUpgradeTask";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block11: {
            try {
                PluginAccessor pluginAccessor = SpringContext.getComponentByClass(PluginAccessor.class);
                PluginSettingsFactory settingsFactory = SpringContext.getComponentByClass(PluginSettingsFactory.class);
                JiraServerService jiraServerService = SpringContext.getComponentByClass(JiraServerService.class);
                Plugin plugin = pluginAccessor.getPlugin("com.atlassian.integration.jira.jira-integration-plugin");
                if (plugin == null) {
                    Logs.APP_LOG.info((Object)"JIRA integration plugin not installed or not found (looked for key 'com.atlassian.integration.jira.jira-integration-plugin')");
                    return;
                }
                PluginState pluginState = plugin.getPluginState();
                if (pluginState.equals((Object)PluginState.ENABLED) || pluginState.equals((Object)PluginState.ENABLING)) {
                    PluginSettings settings = settingsFactory.createGlobalSettings();
                    if (!"true".equals(settings.get(PLUGIN_HAS_COMPLETED_VERSION_CHECK_KEY))) {
                        try {
                            Logs.APP_LOG.info((Object)"Checking if JIRA integration plugin should be enabled");
                            Iterable<JiraServer> jiraServers = jiraServerService.getJiraServers();
                            for (JiraServer jiraServer : jiraServers) {
                                String applinkName = jiraServer.getApplicationLink().getName();
                                try {
                                    RemoteJiraServerVersion version = jiraServer.getVersion();
                                    if (version == null || version.getBuildNumber() >= JIRA_50_BUILDNUMBER) continue;
                                    Logs.APP_LOG.info((Object)("JIRA server '" + applinkName + "'  is version " + version.getVersion() + ", disabling the " + JIRA_INTEGRATION + " plugin"));
                                    SpringContext.getComponentByClass(PluginController.class).disablePlugin(plugin.getKey());
                                    break block11;
                                }
                                catch (Exception ex) {
                                    Logs.APP_LOG.info((Object)("Could not determine JIRA version for server '" + applinkName + "' due to a communication error"));
                                    Logs.APP_LOG.debug((Object)ex);
                                }
                            }
                            break block11;
                        }
                        finally {
                            Logs.APP_LOG.debug((Object)"Recording that JIRA version check for JIRA integration plugin was performed so that it is not repeated on next startup");
                            settings.put(PLUGIN_HAS_COMPLETED_VERSION_CHECK_KEY, (Object)"true");
                        }
                    }
                    Logs.APP_LOG.debug((Object)"JIRA version check has been performed previously - leaving JIRA integration plugin enabled");
                    break block11;
                }
                Logs.APP_LOG.debug((Object)"JIRA integration plugin is disabled");
            }
            catch (Exception ex) {
                Logs.APP_LOG.info((Object)"Unable to determine if JIRA integration plugin should be disabled. The JIRA integration plugin will remain enabled.");
                Logs.APP_LOG.info((Object)"Please see the Crucible upgrade guide at https://confluence.atlassian.com/display/CRUCIBLE/Crucible+3.1+upgrade+guide for more information");
                Logs.APP_LOG.debug((Object)ex);
            }
        }
    }
}

