/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.upgrade;

import com.atlassian.fisheye.dvcs.handler.DvcsProcessException;
import com.atlassian.fisheye.git.GitRepositoryEngine;
import com.atlassian.fisheye.git.client.GitContext;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.cache.InternalRevisionCache;
import com.cenqua.fisheye.cache.RevisionCacheProperties;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.upgrade.AbstractRepositoryVersionUpgradeTask;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Logger;

public class GitPruneExpireNeverUpgradeTask
extends AbstractRepositoryVersionUpgradeTask {
    private static final Logger log = Logs.loggerFor(GitPruneExpireNeverUpgradeTask.class);

    public GitPruneExpireNeverUpgradeTask() {
        super((Map<ScmType, Integer>)ImmutableMap.of((Object)((Object)ScmType.GIT), (Object)21));
    }

    @Override
    public void upgradeRepository(RepositoryEngine engine, RevisionCacheProperties props) throws IOException {
        if (engine instanceof GitRepositoryEngine) {
            InternalRevisionCache<? extends ChangeSet> cache = engine.getInternalRevisionCache();
            GitRepositoryEngine gitEngine = (GitRepositoryEngine)engine;
            if (gitEngine.getContext().getRepoLocation().exists()) {
                this.updateConfig(gitEngine.getContext(), cache, props);
            } else {
                log.info((Object)String.format("Could not update gc.pruneExpire setting on the: %s repository because local clone doesn't exist. Marking this upgrade task as completed", cache.getRepositoryName()));
                this.markUpgradeTaskComplete(cache, props);
            }
        } else {
            throw new IllegalStateException(String.format("Expected GitRepositoryEngine but got %s", engine.getClass()));
        }
    }

    private void updateConfig(GitContext context, InternalRevisionCache<? extends ChangeSet> cache, RevisionCacheProperties props) throws IOException {
        try {
            context.updateLocalCloneConfig("gc.pruneExpire", "never");
            this.markUpgradeTaskComplete(cache, props);
        }
        catch (DvcsProcessException e2) {
            log.warn((Object)String.format("Could not update gc.pruneExpire setting on the: %s repository", cache.getRepositoryName()), (Throwable)e2);
        }
    }

    @Override
    public String getName() {
        return "Updating repository clones with settings: prune --expire=never";
    }
}

