/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.upgrade;

import com.atlassian.fecru.upgrade.SystemUpgradeTask;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.SslServerType;
import com.cenqua.fisheye.config1.WebServerType;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collections;
import org.apache.log4j.Logger;

public class ExcludeKnownVulnerableProtocolsUpgradeTask
implements SystemUpgradeTask {
    static final String SSLV3_PROTOCOL = "SSLv3";
    static final String[] VULNERABLE_PROTOCOLS = new String[]{"SSLv3"};
    private static final Logger log = Logs.loggerFor(ExcludeKnownVulnerableProtocolsUpgradeTask.class);
    private static final String INCLUDE_PROTOCOLS_SECTION = "<includeProtocols> in <ssl> in config.xml";

    @Override
    public void upgradeConfig(RootConfig rootConfig) {
        ConfigDocument.Config config = rootConfig.getConfigDocument().getConfig();
        WebServerType webServer = config.getWebServer();
        if (webServer.isSetSsl()) {
            try {
                this.excludeKnownVulnerableProtocols(rootConfig, webServer.getSsl());
            }
            catch (IOException e2) {
                Throwables.propagate((Throwable)e2);
            }
        }
    }

    private void excludeKnownVulnerableProtocols(RootConfig rootConfig, SslServerType sslType) throws IOException {
        ImmutableSet includeProtocols = sslType.isSetIncludeProtocols() ? ImmutableSet.copyOf((Object[])sslType.getIncludeProtocols().getProtocolArray()) : Collections.emptySet();
        ImmutableSet excludeProtocols = sslType.isSetExcludeProtocols() ? ImmutableSet.copyOf((Object[])sslType.getExcludeProtocols().getProtocolArray()) : Collections.emptySet();
        ImmutableSet.Builder extraExcludeProtocolsBuilder = ImmutableSet.builder();
        for (String protocolToDisableByDefault : VULNERABLE_PROTOCOLS) {
            boolean includedExplicitly = includeProtocols.contains(protocolToDisableByDefault);
            if (includedExplicitly) {
                log.warn((Object)("Starting SSL with protocol " + protocolToDisableByDefault + " enabled. This might be a security vulnerability. " + "Remove it from " + INCLUDE_PROTOCOLS_SECTION + " to disable."));
                continue;
            }
            if (excludeProtocols.contains(protocolToDisableByDefault)) continue;
            extraExcludeProtocolsBuilder.add((Object)protocolToDisableByDefault);
        }
        ImmutableSet extraExcludeProtocols = extraExcludeProtocolsBuilder.build();
        if (!extraExcludeProtocols.isEmpty()) {
            log.info((Object)("Will exclude the following SSL protocols: " + extraExcludeProtocols + ". Add them to " + INCLUDE_PROTOCOLS_SECTION + " to reenable."));
            if (!sslType.isSetExcludeProtocols()) {
                sslType.addNewExcludeProtocols();
            }
            for (String extraExcludeProtocol : extraExcludeProtocols) {
                sslType.getExcludeProtocols().addProtocol(extraExcludeProtocol);
            }
            rootConfig.saveConfig();
        }
    }

    @Override
    public String getName() {
        return "Exclude known vulnerable SSL protocols";
    }
}

