/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.upgrade;

import com.atlassian.fecru.upgrade.BackgroundUpgradeTask;
import com.atlassian.fecru.upgrade.PreUpgradeTask;
import com.atlassian.fecru.upgrade.RepositoryVersionUpgradeTask;
import com.atlassian.fecru.upgrade.SystemUpgradeTask;
import com.atlassian.fecru.upgrade.UpgradeManager;
import com.atlassian.fecru.upgrade.UpgradeTask;
import com.atlassian.fecru.util.ClassUtils;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.cache.RevisionCacheProperties;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.util.ConfigurableThreadFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class DefaultUpgradeManager
implements UpgradeManager {
    static String[] PACKAGE_LIST = new String[]{"com.atlassian.fecru", "com.atlassian.fisheye", "com.atlassian.crucible", "com.cenqua.fisheye", "com.cenqua.crucible"};
    static final String UPGRADE_TASK_NAME_SUFFIX = "UpgradeTask";
    private Comparator<UpgradeTask> taskComparator = new Comparator<UpgradeTask>(){

        @Override
        public int compare(UpgradeTask o1, UpgradeTask o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private Function<UpgradeTask, String> stringifyUpgradeTask = new Function<UpgradeTask, String>(){

        public String apply(@Nullable UpgradeTask task) {
            if (task == null) {
                return null;
            }
            return task.getName();
        }
    };
    private Set<RepositoryVersionUpgradeTask> repoUpgradeTasks = new HashSet<RepositoryVersionUpgradeTask>();
    private Set<BackgroundUpgradeTask> backgroundUpgrades = new TreeSet<UpgradeTask>(this.taskComparator);
    private Set<SystemUpgradeTask> systemUpgradeTasks = new TreeSet<UpgradeTask>(this.taskComparator);
    private Set<PreUpgradeTask> preUpgradeTasks = new TreeSet<UpgradeTask>(this.taskComparator);
    @VisibleForTesting
    static DefaultUpgradeManager instance = new DefaultUpgradeManager();
    private static final int BACKGROUND_POOLSIZE = 2;
    private static final String PROFILE_CLASSFIND = "Finding Upgrade Classes";

    public static UpgradeManager getInstance() {
        return instance;
    }

    public DefaultUpgradeManager() {
        HashSet<Class<UpgradeTask>> upgradeClasses = new HashSet<Class<UpgradeTask>>();
        for (String packageName : PACKAGE_LIST) {
            upgradeClasses.addAll(this.getImplementations(packageName, UPGRADE_TASK_NAME_SUFFIX, UpgradeTask.class));
        }
        for (Class clazz : upgradeClasses) {
            try {
                UpgradeTask task = (UpgradeTask)clazz.newInstance();
                if (task instanceof BackgroundUpgradeTask) {
                    this.backgroundUpgrades.add((BackgroundUpgradeTask)task);
                }
                if (task instanceof RepositoryVersionUpgradeTask) {
                    this.repoUpgradeTasks.add((RepositoryVersionUpgradeTask)task);
                }
                if (task instanceof SystemUpgradeTask) {
                    this.systemUpgradeTasks.add((SystemUpgradeTask)task);
                }
                if (!(task instanceof PreUpgradeTask)) continue;
                this.preUpgradeTasks.add((PreUpgradeTask)task);
            }
            catch (InstantiationException e2) {
                throw new RuntimeException("Unable to instantiate upgrade task " + clazz, e2);
            }
            catch (IllegalAccessException e3) {
                throw new RuntimeException("Unable to instantiate upgrade task " + clazz, e3);
            }
        }
        if (this.backgroundUpgrades.size() > 0 || this.repoUpgradeTasks.size() > 0 || this.systemUpgradeTasks.size() > 0) {
            Logs.APP_LOG.info((Object)"UpgradeManager started.");
        }
        if (Logs.APP_LOG.isDebugEnabled()) {
            Logs.APP_LOG.debug((Object)("Background Upgrade Tasks Found: " + Iterables.transform(this.backgroundUpgrades, this.stringifyUpgradeTask)));
            Logs.APP_LOG.debug((Object)("Repository Upgrade Tasks Found: " + Iterables.transform(this.repoUpgradeTasks, this.stringifyUpgradeTask)));
            Logs.APP_LOG.debug((Object)("System Upgrade Tasks Found: " + Iterables.transform(this.systemUpgradeTasks, this.stringifyUpgradeTask)));
        }
    }

    private <T> Set<Class<T>> getImplementations(String packageName, String nameSuffix, Class<T> required) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        return ClassUtils.getImplementations(classLoader, packageName, nameSuffix, required);
    }

    @Override
    public void startBackgroundTasks() {
        if (this.backgroundUpgrades.size() > 0) {
            ThreadPoolExecutor backgroundThreadPool = new ThreadPoolExecutor(2, 2, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ConfigurableThreadFactory("BackgroundUpdateTaskThread", false));
            for (BackgroundUpgradeTask backgroundUpgrade : this.backgroundUpgrades) {
                backgroundThreadPool.execute(backgroundUpgrade);
            }
            backgroundThreadPool.shutdown();
        }
    }

    @Override
    public void upgradeRootConfig(RootConfig rootConfig) {
        for (SystemUpgradeTask task : this.systemUpgradeTasks) {
            task.upgradeConfig(rootConfig);
        }
    }

    @Override
    @Deprecated
    public void upgradeRootData(RootConfig rootConfig) {
    }

    @Override
    public boolean preUpgradeCheck(RootConfig rootConfig) {
        for (PreUpgradeTask task : this.preUpgradeTasks) {
            if (task.preUpgradeCheck(rootConfig)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isRepositoryUpgradable(ScmType repoType, int fromVersion, int toVersion) {
        List<RepositoryVersionUpgradeTask> upgradePath = this.getUpgradePath(repoType, fromVersion, toVersion);
        return !upgradePath.isEmpty();
    }

    @VisibleForTesting
    public List<RepositoryVersionUpgradeTask> getUpgradePath(ScmType repoType, int fromVersion, int toVersion) {
        ArrayList<RepositoryVersionUpgradeTask> path = new ArrayList<RepositoryVersionUpgradeTask>();
        int upgradeVersion = fromVersion;
        while (upgradeVersion != toVersion) {
            StringBuilder message;
            boolean stepAdded = false;
            for (RepositoryVersionUpgradeTask task : this.repoUpgradeTasks) {
                Integer targetVersion = task.canUpgrade(repoType, upgradeVersion);
                if (targetVersion == null || targetVersion > toVersion) continue;
                path.add(task);
                upgradeVersion = targetVersion;
                stepAdded = true;
                break;
            }
            if (!stepAdded) {
                if (Logs.APP_LOG.isDebugEnabled()) {
                    message = new StringBuilder();
                    message.append("Unable to find an upgrade path for ").append(repoType.getFullName());
                    message.append(" repository from ").append(fromVersion);
                    message.append(" to ").append(toVersion);
                    if (upgradeVersion != fromVersion) {
                        message.append(" - can only upgrade to ").append(upgradeVersion);
                    }
                    Logs.APP_LOG.debug((Object)message.toString());
                }
                return Collections.emptyList();
            }
            if (!Logs.APP_LOG.isDebugEnabled()) continue;
            message = new StringBuilder();
            message.append("Upgrade path for ").append(repoType.getFullName());
            message.append(" repository from ").append(fromVersion);
            message.append(" to ").append(toVersion).append(": ").append(Iterables.transform(path, this.stringifyUpgradeTask));
            Logs.APP_LOG.debug((Object)message.toString());
        }
        return path;
    }

    @Override
    public void upgradeRepository(RepositoryEngine engine, RevisionCacheProperties props, int toVersion) throws IOException, ConfigException {
        Logs.APP_LOG.info((Object)String.format("Starting upgrade of repository %s from version %d to version %d", engine.getName(), props.getVersion(), toVersion));
        ScmType repoType = engine.getCfg().getRepositoryType();
        List<RepositoryVersionUpgradeTask> upgradePath = this.getUpgradePath(repoType, props.getVersion(), toVersion);
        for (RepositoryVersionUpgradeTask upgradeTask : upgradePath) {
            Integer upgradeToVersion = upgradeTask.canUpgrade(repoType, props.getVersion());
            upgradeTask.upgradeRepository(engine, props);
            if (upgradeToVersion.intValue() == props.getVersion()) continue;
            Logs.APP_LOG.error((Object)String.format("Unable to upgrade repository %s using upgrade %s to version %d", engine.getName(), upgradeTask.getName(), upgradeToVersion));
            throw new ConfigException("Upgrade Failure");
        }
        Logs.APP_LOG.info((Object)String.format("Repository %s upgraded to version %d", engine.getName(), props.getVersion()));
    }
}

