/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.upgrade;

import com.atlassian.fecru.upgrade.PreUpgradeTask;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.RepositoryType;
import java.util.ArrayList;

public class ClearcaseRemovalUpgradeTask
implements PreUpgradeTask {
    @Override
    public boolean preUpgradeCheck(RootConfig rootConfig) {
        ArrayList<String> clearCaseRepositories = new ArrayList<String>();
        for (RepositoryType repositoryType : rootConfig.getConfig().getRepositoryArray()) {
            if (!repositoryType.isSetClearcase()) continue;
            clearCaseRepositories.add(repositoryType.getName());
        }
        if (clearCaseRepositories.isEmpty()) {
            return true;
        }
        String productName = rootConfig.getProductName();
        UWL.warn3Banners();
        UWL.warn("ClearCase repositories are no longer supported by " + productName + ". ");
        if (Boolean.getBoolean("fisheye.clearcase.disable")) {
            UWL.warn("  You have forced startup with " + (clearCaseRepositories.size() > 1 ? "ClearCase repositories" : "a ClearCase repository") + " present.");
            UWL.warn("  Please refer to https://confluence.atlassian.com/display/FISHEYE/Upgrading+from+FishEye+2.7+with+existing+ClearCase+Repositories for more information.");
            UWL.warn("");
            UWL.warn("  The following " + (clearCaseRepositories.size() > 1 ? "repositories" : "repository") + " in your configuration will not start and cannot be enabled");
            for (String repoName : clearCaseRepositories) {
                UWL.warn("      * " + repoName);
            }
            UWL.warn3Banners();
            return true;
        }
        UWL.warn("  You can either:");
        UWL.warn("    1. Start the old version of " + productName + " and remove the ClearCase");
        UWL.warn("       repositories, then continue with the upgrade");
        UWL.warn("         or");
        UWL.warn("    2. Start " + productName + " with the system property " + "fisheye.clearcase.disable" + " set to true.");
        UWL.warn("       You can set this by adding a java system property to the FISHEYE_OPTS environment variable:");
        UWL.warn("         -Dfisheye.clearcase.disable=true");
        UWL.warn("");
        UWL.warn("  Please refer to https://confluence.atlassian.com/display/FISHEYE/Upgrading+from+FishEye+2.7+with+existing+ClearCase+Repositories for more information.");
        UWL.warn("");
        UWL.warn("  You have the following ClearCase " + (clearCaseRepositories.size() > 1 ? "repositories" : "repository") + " in your configuration");
        for (String repoName : clearCaseRepositories) {
            UWL.warn("      * " + repoName);
        }
        UWL.warn3Banners();
        return false;
    }

    @Override
    public String getName() {
        return "ClearcaseEOL";
    }
}

