/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.tx;

import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.base.Preconditions;
import org.springframework.transaction.IllegalTransactionStateException;
import org.springframework.transaction.NestedTransactionNotSupportedException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;

public class TxHelperStylePlatformTransactionManager
implements PlatformTransactionManager {
    public TransactionStatus getTransaction(TransactionDefinition txDefinition) throws TransactionException {
        if (txDefinition != null && txDefinition.getPropagationBehavior() == 5) {
            if (HibernateUtil.isCurrentTransaction()) {
                throw new IllegalTransactionStateException("Existing transaction found for transaction marked with propagation 'never'");
            }
            return new NoopTransactionStatus();
        }
        TxHelperConfigurableStatus txHelperConfigurableStatus = new TxHelperConfigurableStatus();
        txHelperConfigurableStatus.alreadyCommitted = false;
        HibernateUtil.beginTransaction();
        return txHelperConfigurableStatus;
    }

    public void commit(TransactionStatus status) throws TransactionException {
        Preconditions.checkNotNull((Object)status);
        if (status instanceof NoopTransactionStatus) {
            return;
        }
        if (!(status instanceof TxHelperConfigurableStatus)) {
            throw new IllegalArgumentException("not TxHelperConfigurableStatus? : " + status.getClass());
        }
        ((TxHelperConfigurableStatus)status).alreadyCommitted = true;
        HibernateUtil.commitTransaction();
    }

    public void rollback(TransactionStatus status) throws TransactionException {
        Preconditions.checkNotNull((Object)status);
        if (status instanceof NoopTransactionStatus) {
            return;
        }
        if (status instanceof TxHelperConfigurableStatus) {
            if (!((TxHelperConfigurableStatus)status).alreadyCommitted) {
                Throwable stackTrace = HibernateUtil.getTransactionBeginStacktrace();
                HibernateUtil.rollbackTransactionIfNotCommitted();
                HibernateUtil.closeSession();
                if (stackTrace != null) {
                    Logs.APP_LOG.debug((Object)"Rolled back transaction started from:", stackTrace);
                } else {
                    Logs.APP_LOG.debug((Object)"Rolled back transaction");
                }
            }
        } else {
            throw new IllegalArgumentException("not TxHelperConfigurableStatus? : " + status.getClass());
        }
    }

    private static class NoopTransactionStatus
    extends TxHelperConfigurableStatus {
        private NoopTransactionStatus() {
        }
    }

    private static class TxHelperConfigurableStatus
    implements TransactionStatus {
        private boolean markedForRollback = false;
        private boolean alreadyCommitted;

        private TxHelperConfigurableStatus() {
        }

        public boolean isNewTransaction() {
            return true;
        }

        public boolean hasSavepoint() {
            return false;
        }

        public void setRollbackOnly() {
            this.markedForRollback = true;
        }

        public boolean isRollbackOnly() {
            return this.markedForRollback;
        }

        public boolean isCompleted() {
            return false;
        }

        public Object createSavepoint() throws TransactionException {
            throw new NestedTransactionNotSupportedException("Nested transactions not supported by: " + TxHelperStylePlatformTransactionManager.class.getName());
        }

        public void rollbackToSavepoint(Object savepoint) throws TransactionException {
            throw new NestedTransactionNotSupportedException("Nested transactions not supported by: " + TxHelperStylePlatformTransactionManager.class.getName());
        }

        public void releaseSavepoint(Object savepoint) throws TransactionException {
            throw new NestedTransactionNotSupportedException("Nested transactions not supported by: " + TxHelperStylePlatformTransactionManager.class.getName());
        }

        public void flush() {
        }
    }
}

