/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.tx;

import com.google.common.base.Preconditions;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class SpringThreadLocalTransaction {
    private final ThreadLocal<TransactionStatus> transactionStatusThreadLocal = new ThreadLocal();
    private final PlatformTransactionManager platformTransactionManager;

    public SpringThreadLocalTransaction(PlatformTransactionManager platformTransactionManager) {
        this.platformTransactionManager = platformTransactionManager;
    }

    public void begin() {
        Preconditions.checkState((this.transactionStatusThreadLocal.get() == null ? 1 : 0) != 0, (Object)"A transaction should not be active");
        this.transactionStatusThreadLocal.set(this.platformTransactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition()));
    }

    public void commit() {
        this.platformTransactionManager.commit(this.getActiveTransactionStatus());
        this.transactionStatusThreadLocal.remove();
    }

    public void rollback() {
        this.platformTransactionManager.rollback(this.getActiveTransactionStatus());
        this.transactionStatusThreadLocal.remove();
    }

    private TransactionStatus getActiveTransactionStatus() {
        return (TransactionStatus)Preconditions.checkNotNull((Object)this.transactionStatusThreadLocal.get(), (Object)"A transaction should be active");
    }
}

