/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.tx;

import com.atlassian.crucible.spi.TxCallback;
import com.atlassian.fecru.user.EffectiveUserProviderImpl;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.spi.TxTemplate;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.user.UserLogin;
import com.google.common.base.Throwables;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class SpringPlatformTransactionManagerTxTemplate
implements TxTemplate {
    private final PlatformTransactionManager platformTransactionManager;
    private final EffectiveUserProviderImpl effectiveUserProvider;

    public SpringPlatformTransactionManagerTxTemplate(PlatformTransactionManager platformTransactionManager, EffectiveUserProviderImpl effectiveUserProvider) {
        this.platformTransactionManager = platformTransactionManager;
        this.effectiveUserProvider = effectiveUserProvider;
    }

    @Override
    public <T> T execute(final TxCallback<T> txCallback) {
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.platformTransactionManager);
        return (T)transactionTemplate.execute(new TransactionCallback<T>(){

            public T doInTransaction(TransactionStatus status) {
                try {
                    return txCallback.doInTransaction(status);
                }
                catch (Exception e2) {
                    throw Throwables.propagate((Throwable)e2);
                }
            }
        });
    }

    @Override
    public void pushEffectivePrincipal(Principal principal, FecruUser user) {
        this.effectiveUserProvider.pushEffectivePrincipal(principal, user);
    }

    @Override
    public void popEffectivePrincipal() {
        this.effectiveUserProvider.popEffectivePrincipal();
    }

    @Override
    public void setEffectivePrincipal(Principal principal, FecruUser user) {
        this.effectiveUserProvider.setEffectivePrincipal(principal, user);
    }

    @Override
    public Principal getEffectivePrincipal() {
        return this.effectiveUserProvider.getEffectivePrincipal();
    }

    @Override
    public UserLogin getEffectiveUserLogin() {
        return this.effectiveUserProvider.getEffectiveUserLogin();
    }

    @Override
    public boolean isAdmin() {
        return this.effectiveUserProvider.isAdmin();
    }

    @Override
    public FecruUser getEffectiveCrucibleUser() {
        return this.effectiveUserProvider.getEffectiveUser();
    }
}

