/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.tenancy.compatibility;

import com.atlassian.fecru.tenancy.compatibility.FeCruCompatibilityTenant;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.tenancy.api.Tenant;
import com.atlassian.tenancy.api.TenantAccessor;
import com.atlassian.tenancy.api.TenantContext;
import com.atlassian.tenancy.api.TenantUnavailableException;
import com.atlassian.tenancy.api.UnexpectedTenantChangeException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.concurrent.Callable;
import org.springframework.stereotype.Component;

@Component(value="tenantAccessor")
@AvailableToPlugins
public class FeCruCompatibilityTenantAccessor
implements TenantAccessor,
TenantContext {
    private static final Tenant TENANT = new FeCruCompatibilityTenant();

    public Tenant getCurrentTenant() {
        return TENANT;
    }

    public Iterable<Tenant> getAvailableTenants() {
        return Collections.singleton(TENANT);
    }

    public <T> T asTenant(Tenant tenant, Callable<T> call) throws InvocationTargetException, TenantUnavailableException {
        if (!tenant.equals(TENANT)) {
            throw new UnexpectedTenantChangeException();
        }
        try {
            return call.call();
        }
        catch (Exception e2) {
            throw new InvocationTargetException(e2);
        }
    }
}

