/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.template;

import com.atlassian.fecru.template.TemplateManager;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.springframework.stereotype.Service;

@Service(value="templateManager")
public class DefaultTemplateManager
implements TemplateManager {
    private Configuration templateConfig = new Configuration();

    public DefaultTemplateManager() throws IOException {
        this.templateConfig.setTemplateLoader((TemplateLoader)new MultiTemplateLoader((TemplateLoader[])this.getTemplateLoaders()));
        this.templateConfig.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        this.templateConfig.setURLEscapingCharset("UTF-8");
    }

    private FileTemplateLoader[] getTemplateLoaders() throws IOException {
        File appHomeTemplateDir;
        ArrayList<FileTemplateLoader> loaders = new ArrayList<FileTemplateLoader>();
        File templateDir = new File(AppConfig.getInstanceDir(), "template");
        if (!IOHelper.isSameFile(AppConfig.getInstanceDir(), AppConfig.getAppHome()) && templateDir.exists() && templateDir.isDirectory()) {
            loaders.add(new FileTemplateLoader(templateDir));
            Logs.APP_LOG.info((Object)("using custom template directory of " + templateDir));
        }
        if (!((appHomeTemplateDir = new File(AppConfig.getAppHome(), "template")).exists() && appHomeTemplateDir.isDirectory() && appHomeTemplateDir.canRead())) {
            Logs.APP_LOG.debug((Object)("Couldn't read from FISHEYE_HOME directory at " + appHomeTemplateDir.getCanonicalPath()));
            throw new IOException("Could not read from FISHEYE_HOME at " + appHomeTemplateDir.getCanonicalPath());
        }
        loaders.add(new FileTemplateLoader(appHomeTemplateDir));
        return loaders.toArray(new FileTemplateLoader[loaders.size()]);
    }

    @Override
    public Template getTemplate(String templateName) throws IOException {
        return this.templateConfig.getTemplate(templateName);
    }

    @Override
    public Template getFishEyeTemplate(String templateName, boolean isHtml) throws IOException {
        String contentType = isHtml ? "html" : "plain";
        return this.templateConfig.getTemplate("fisheye/" + contentType + "/" + templateName);
    }

    @Override
    public Template getCrucibleTemplate(String templateName, boolean isHtml) throws IOException {
        String contentType = isHtml ? "html" : "plain";
        return this.templateConfig.getTemplate("crucible/" + contentType + "/" + templateName);
    }
}

