/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.security;

import com.atlassian.fecru.security.SshKeyCredentials;
import com.atlassian.utils.process.ExternalProcessBuilder;
import com.cenqua.fisheye.AppConfig;
import com.google.common.base.Preconditions;
import java.io.File;
import org.apache.commons.lang.SystemUtils;

public class SshWrapper {
    private static final String FE_SSH_EXEC_VAR = "SSH_EXEC";
    private static final String FE_SSH_KEY_VAR = "FE_SSH_KEY";
    private static final String UX_FE_SSH_WRAPPER = "fe-ssh.sh";
    private static final String WIN_FE_SSH_WRAPPER = "fe-ssh.bat";
    private String pathToSsh;

    public SshWrapper(String pathToSsh) {
        Preconditions.checkNotNull((Object)pathToSsh, (Object)"Could not find SSH binary on the system path. See https://confluence.atlassian.com/display/FISHEYE/Authentication");
        this.pathToSsh = pathToSsh;
    }

    public static String getSshWrapperCmd(boolean isGit) {
        if (SystemUtils.IS_OS_WINDOWS && !isGit) {
            return "call \"" + new File(AppConfig.getBinDir(), WIN_FE_SSH_WRAPPER).getAbsolutePath() + "\"";
        }
        return new File(AppConfig.getBinDir(), UX_FE_SSH_WRAPPER).getAbsolutePath();
    }

    public ExternalProcessBuilder setSshWrapperVariables(ExternalProcessBuilder builder, SshKeyCredentials credentials) {
        return builder.env(FE_SSH_EXEC_VAR, this.pathToSsh).env(FE_SSH_KEY_VAR, credentials.getPrivateKey().getAbsolutePath());
    }
}

